/*
 * Decompiled with CFR 0.152.
 */
package phex.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.AndConcatCondition;
import phex.rules.condition.Condition;
import phex.rules.consequence.Consequence;

public class Rule
implements Cloneable {
    private String name;
    private String description;
    private String id;
    private boolean isPermanentlyEnabled;
    private boolean isDefaultRule;
    private AndConcatCondition ruleCondition = new AndConcatCondition();
    private List consequences = new ArrayList();

    public boolean isDefaultRule() {
        return this.isDefaultRule;
    }

    public void setDefaultRule(boolean bl) {
        this.isDefaultRule = bl;
    }

    public boolean isPermanentlyEnabled() {
        return this.isPermanentlyEnabled;
    }

    public void setPermanentlyEnabled(boolean bl) {
        this.isPermanentlyEnabled = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public List getConditions() {
        return this.ruleCondition.getConditions();
    }

    public void clearConditions() {
        this.ruleCondition.clearConditions();
    }

    public Rule addCondition(Condition condition) {
        this.ruleCondition.addCondition(condition);
        return this;
    }

    public Rule removeCondition(Condition condition) {
        this.ruleCondition.removeCondition(condition);
        return this;
    }

    public List getConsequences() {
        return Collections.unmodifiableList(this.consequences);
    }

    public void addConsequence(Consequence consequence) {
        this.consequences.add(consequence);
    }

    public Rule removeConsequence(Consequence consequence) {
        this.consequences.remove(consequence);
        return this;
    }

    public void process(Search search, RemoteFile[] remoteFileArray) {
        for (int i = 0; i < remoteFileArray.length; ++i) {
            boolean bl;
            if (remoteFileArray[i].isFilteredRemoved() || !(bl = this.ruleCondition.isMatched(search, remoteFileArray[i]))) continue;
            Iterator iterator = this.consequences.iterator();
            while (iterator.hasNext()) {
                Consequence consequence = (Consequence)iterator.next();
                consequence.invoke(search, remoteFileArray[i]);
            }
        }
    }

    public Object clone() {
        try {
            Rule rule = (Rule)super.clone();
            rule.ruleCondition = (AndConcatCondition)this.ruleCondition.clone();
            rule.consequences = new ArrayList();
            Iterator iterator = this.consequences.iterator();
            while (iterator.hasNext()) {
                Consequence consequence = (Consequence)iterator.next();
                rule.consequences.add(consequence.clone());
            }
            return rule;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

