/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFileSizeCondition;

public class FileSizeCondition
implements Condition {
    private ListOrderedSet ranges = new ListOrderedSet();

    public FileSizeCondition() {
    }

    public FileSizeCondition(long l, long l2) {
        this();
        this.addRange(l, l2);
    }

    public FileSizeCondition(FileSizeCondition fileSizeCondition) {
        this();
        this.update(fileSizeCondition);
    }

    public synchronized void update(FileSizeCondition fileSizeCondition) {
        this.ranges.clear();
        Iterator iterator = fileSizeCondition.ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            this.ranges.add(new Range(range.min, range.max));
        }
    }

    public synchronized int getRangesCount() {
        return this.ranges.size();
    }

    public synchronized Set getRanges() {
        return Collections.unmodifiableSet(this.ranges);
    }

    public synchronized List getRangesList() {
        return this.ranges.asList();
    }

    public synchronized FileSizeCondition addRange(long l, long l2) {
        this.ranges.add(new Range(l, l2));
        return this;
    }

    public synchronized FileSizeCondition addRange(Range range) {
        this.ranges.add(range);
        return this;
    }

    public synchronized void removeRange(Range range) {
        this.ranges.remove(range);
    }

    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        long l = remoteFile.getFileSize();
        Iterator iterator = this.ranges.iterator();
        while (iterator.hasNext()) {
            Range range = (Range)iterator.next();
            if (range.min >= 0L && l < range.min || range.max >= 0L && l > range.max) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this.getRangesCount() > 0;
    }

    public synchronized Object clone() {
        try {
            FileSizeCondition fileSizeCondition = (FileSizeCondition)super.clone();
            fileSizeCondition.ranges = new ListOrderedSet();
            fileSizeCondition.ranges.addAll((Collection)this.ranges);
            return fileSizeCondition;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized DCondition createDCondition() {
        DFileSizeCondition dFileSizeCondition = new DFileSizeCondition();
        ArrayList arrayList = new ArrayList(this.ranges);
        dFileSizeCondition.setRanges(arrayList);
        return dFileSizeCondition;
    }

    public static FileSizeCondition create(DFileSizeCondition dFileSizeCondition) {
        FileSizeCondition fileSizeCondition = new FileSizeCondition();
        fileSizeCondition.ranges.addAll((Collection)dFileSizeCondition.getRanges());
        return fileSizeCondition;
    }

    public static class Range {
        public long min;
        public long max;

        public Range(long l, long l2) {
            this.min = l;
            this.max = l2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range range = (Range)object;
            return range.min == this.min && range.max == this.max;
        }

        public int hashCode() {
            int n = 629 + (int)(this.min ^ this.min >> 32);
            n = n * 37 + (int)(this.max ^ this.max >> 32);
            return n;
        }
    }
}

