/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DFilenameCondition;

public class FilenameCondition
implements Condition {
    private ListOrderedSet terms = new ListOrderedSet();

    public FilenameCondition() {
    }

    public FilenameCondition(FilenameCondition filenameCondition) {
        this();
        this.update(filenameCondition);
    }

    public synchronized void update(FilenameCondition filenameCondition) {
        this.terms.clear();
        this.terms.addAll((Collection)filenameCondition.terms);
    }

    public synchronized int getTermsCount() {
        return this.terms.size();
    }

    public synchronized Set getTerms() {
        return Collections.unmodifiableSet(this.terms);
    }

    public synchronized List getTermsList() {
        return this.terms.asList();
    }

    public synchronized FilenameCondition addTerm(String string) {
        string = string.toLowerCase();
        this.terms.add(string);
        return this;
    }

    public synchronized void removeTerm(String string) {
        this.terms.remove(string);
    }

    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        String string = remoteFile.getFilename();
        string = string.toLowerCase();
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) == -1) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this.getTermsCount() > 0;
    }

    public synchronized Object clone() {
        try {
            FilenameCondition filenameCondition = (FilenameCondition)super.clone();
            filenameCondition.terms = new ListOrderedSet();
            filenameCondition.terms.addAll((Collection)this.terms);
            return filenameCondition;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized DCondition createDCondition() {
        DFilenameCondition dFilenameCondition = new DFilenameCondition();
        ArrayList arrayList = new ArrayList(this.terms);
        dFilenameCondition.setTerms(arrayList);
        return dFilenameCondition;
    }
}

