/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import phex.common.Cfg;
import phex.common.ServiceManager;
import phex.common.ThreadTracking;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedDirectory;
import phex.share.SharedFilesService;
import phex.utils.NLogger;
import phex.xml.sax.share.DSharedFile;
import phex.xml.sax.share.DSharedLibrary;

public class FileRescanRunner
implements Runnable {
    private static Thread rescanThread;
    private SharedFilesService sharedFilesService;
    private ArrayList sharedDirectoryFiles;
    private List exclusionPatterns;
    private HashMap sharedDirectoryMap;
    private HashSet sharedDirectoryList;
    private boolean isInitialRescan;
    private HashMap sharedFilesCache;

    private FileRescanRunner(boolean bl) {
        this.isInitialRescan = bl;
        this.sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        this.sharedDirectoryFiles = new ArrayList(5);
        this.exclusionPatterns = new ArrayList();
        this.sharedDirectoryMap = new HashMap();
        this.sharedDirectoryList = new HashSet(5);
    }

    public static void rescan(boolean bl, boolean bl2) {
        if (bl2 && rescanThread != null && !rescanThread.isInterrupted() && rescanThread.isAlive()) {
            NLogger.debug("LIBRARY_SCANNER", (Object)"Interrupting rescan thread.");
            rescanThread.interrupt();
            try {
                NLogger.debug("LIBRARY_SCANNER", (Object)"Waiting for interrupted rescan thread.");
                rescanThread.join();
            }
            catch (InterruptedException interruptedException) {
                NLogger.warn("LIBRARY_SCANNER", (Object)interruptedException, (Throwable)interruptedException);
            }
        }
        if (rescanThread == null || !rescanThread.isAlive()) {
            FileRescanRunner fileRescanRunner = new FileRescanRunner(bl);
            rescanThread = new Thread(ThreadTracking.rootThreadGroup, fileRescanRunner, "FileRescanRunner-" + Integer.toHexString(fileRescanRunner.hashCode()));
            rescanThread.setDaemon(true);
            rescanThread.setPriority(1);
            rescanThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        NLogger.debug("LIBRARY_SCANNER", (Object)("Staring file rescan (Initial: " + this.isInitialRescan + ")."));
        Cfg cfg = ServiceManager.sCfg;
        this.sharedDirectoryFiles = new ArrayList(cfg.sharedDirectoriesSet);
        this.setExclusionFilter(cfg.libraryExclusionRegExList);
        if (rescanThread.isInterrupted()) {
            return;
        }
        if (this.isInitialRescan) {
            this.sharedFilesService.clearSharedFiles();
            if (rescanThread.isInterrupted()) {
                return;
            }
            this.buildSharedFilesCache();
        } else {
            this.removeUnsharedFiles();
        }
        if (rescanThread.isInterrupted()) {
            return;
        }
        try {
            this.sharedFilesService.setCalculationRunnerPause(true);
            HashMap hashMap = new HashMap();
            Iterator iterator = this.sharedDirectoryFiles.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                File file = new File(string);
                this.scanDir(file, hashMap);
                if (!rescanThread.isInterrupted()) continue;
                return;
            }
            this.sharedFilesService.updateSharedDirecotries(this.sharedDirectoryMap, this.sharedDirectoryList);
            this.sharedFilesService.triggerSaveSharedFiles();
        }
        finally {
            this.sharedFilesService.setCalculationRunnerPause(false);
        }
    }

    private void buildSharedFilesCache() {
        this.sharedFilesCache = new HashMap();
        DSharedLibrary dSharedLibrary = this.sharedFilesService.loadSharedLibrary();
        if (dSharedLibrary == null) {
            return;
        }
        Iterator iterator = dSharedLibrary.getSubElementList().iterator();
        while (iterator.hasNext() && !rescanThread.isInterrupted()) {
            DSharedFile dSharedFile = (DSharedFile)iterator.next();
            this.sharedFilesCache.put(dSharedFile.getFileName(), dSharedFile);
        }
    }

    private void scanDir(File file, HashMap hashMap) {
        File[] fileArray;
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            NLogger.warn("LIBRARY_SCANNER", (Object)iOException, (Throwable)iOException);
            return;
        }
        if (hashMap.containsKey(string)) {
            return;
        }
        hashMap.put(string, "");
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.handleScannedDir(file);
        }
        if ((fileArray = file.listFiles()) == null) {
            NLogger.error("LIBRARY_SCANNER", "'" + file + "' is not a directory.");
            return;
        }
        for (int i = 0; i < fileArray.length && !rescanThread.isInterrupted(); ++i) {
            if (this.isFileInvalid(fileArray[i]) || !fileArray[i].isFile()) continue;
            this.handleScannedFile(fileArray[i]);
        }
    }

    private void handleScannedDir(File file) {
        SharedDirectory sharedDirectory;
        if (rescanThread.isInterrupted()) {
            return;
        }
        if (this.isInitialRescan) {
            sharedDirectory = (SharedDirectory)this.sharedDirectoryMap.get(file);
            if (sharedDirectory == null) {
                sharedDirectory = new SharedDirectory(file);
                sharedDirectory.setType((short)1);
                this.sharedDirectoryMap.put(file, sharedDirectory);
                this.sharedDirectoryList.add(sharedDirectory);
            } else {
                sharedDirectory.setType((short)1);
            }
        } else {
            sharedDirectory = (SharedDirectory)this.sharedDirectoryMap.get(file);
            if (sharedDirectory == null) {
                sharedDirectory = new SharedDirectory(file);
                sharedDirectory.setType((short)1);
                this.sharedDirectoryMap.put(file, sharedDirectory);
                this.sharedDirectoryList.add(sharedDirectory);
            } else {
                sharedDirectory.setType((short)1);
            }
        }
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            if (!file2.isDirectory() || (sharedDirectory = (SharedDirectory)this.sharedDirectoryMap.get(file2)) != null) continue;
            sharedDirectory = new SharedDirectory(file2);
            sharedDirectory.setType((short)2);
            this.sharedDirectoryMap.put(file2, sharedDirectory);
            this.sharedDirectoryList.add(sharedDirectory);
        }
    }

    private void handleScannedFile(File file) {
        if (this.isInitialRescan) {
            ShareFile shareFile = new ShareFile(file);
            DSharedFile dSharedFile = (DSharedFile)this.sharedFilesCache.get(file.getAbsolutePath());
            if (dSharedFile != null && dSharedFile.getLastModified() == file.lastModified()) {
                shareFile.updateFromCache(dSharedFile);
                this.sharedFilesService.addUrn2FileMapping(shareFile);
            } else {
                this.sharedFilesService.queueUrnCalculation(shareFile);
                if (rescanThread.isInterrupted()) {
                    return;
                }
            }
            this.sharedFilesService.addSharedFile(shareFile);
        } else {
            ShareFile shareFile = this.sharedFilesService.getFileByName(file.getAbsolutePath());
            if (shareFile == null) {
                shareFile = new ShareFile(file);
                this.sharedFilesService.queueUrnCalculation(shareFile);
                if (rescanThread.isInterrupted()) {
                    return;
                }
                this.sharedFilesService.addSharedFile(shareFile);
            }
        }
    }

    private void removeUnsharedFiles() {
        ShareFile[] shareFileArray = this.sharedFilesService.getSharedFiles();
        for (int i = 0; i < shareFileArray.length && !rescanThread.isInterrupted(); ++i) {
            File file = shareFileArray[i].getSystemFile();
            if (this.isInSharedDirectory(file) && file.exists()) continue;
            this.sharedFilesService.removeSharedFile(shareFileArray[i]);
        }
    }

    private boolean isInSharedDirectory(File file) {
        Iterator iterator = this.sharedDirectoryFiles.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file2 = new File(string);
            if (!file.getParentFile().equals(file2)) continue;
            return true;
        }
        return false;
    }

    private void setSharedDirectories(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        this.sharedDirectoryFiles.clear();
        this.sharedDirectoryFiles.ensureCapacity(n);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken().trim());
            if (this.sharedDirectoryFiles.contains(file)) continue;
            this.sharedDirectoryFiles.add(file);
        }
    }

    private void setExclusionFilter(List list) {
        this.exclusionPatterns.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Pattern pattern = Pattern.compile(string);
                this.exclusionPatterns.add(pattern);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                NLogger.error("LIBRARY_SCANNER", (Object)patternSyntaxException, (Throwable)patternSyntaxException);
            }
        }
    }

    public boolean isFileInvalid(File file) {
        if (file.getName().toLowerCase().endsWith(".dl")) {
            return true;
        }
        return this.isExcludedRegExp(file);
    }

    private boolean isExcludedRegExp(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = file.getName();
        Iterator iterator = this.exclusionPatterns.iterator();
        while (iterator.hasNext()) {
            Pattern pattern = (Pattern)iterator.next();
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }
}

