/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import phex.common.AltLocContainer;
import phex.common.URN;
import phex.download.swarming.SWDownloadFile;
import phex.http.HTTPRangeSet;
import phex.http.Range;
import phex.share.ShareFile;
import phex.xml.sax.share.DSharedFile;

public class PartialShareFile
extends ShareFile {
    private SWDownloadFile swDownloadFile;
    private HTTPRangeSet availableRangeSet;
    private File partialFile;
    private long fileStartOffset;

    public PartialShareFile(SWDownloadFile sWDownloadFile) {
        super(sWDownloadFile.getTotalDataSize());
        this.swDownloadFile = sWDownloadFile;
        this.availableRangeSet = this.swDownloadFile.createAvailableRangeSet();
    }

    public URN getURN() {
        return this.swDownloadFile.getFileURN();
    }

    public String getSHA1() {
        URN uRN = this.swDownloadFile.getFileURN();
        if (uRN == null || !uRN.isSha1Nid()) {
            return "";
        }
        return uRN.getNamespaceSpecificString();
    }

    public String getFileName() {
        return this.swDownloadFile.getDestinationFile().getName();
    }

    public AltLocContainer getAltLocContainer() {
        return this.swDownloadFile.getGoodAltLocContainer();
    }

    public short getRangeAvailableStatus(Range range) {
        long l = this.getFileSize();
        Iterator iterator = this.availableRangeSet.getIterator();
        while (iterator.hasNext()) {
            Range range2 = (Range)iterator.next();
            if (!range2.isRangeSatisfiable(range, l)) continue;
            return 0;
        }
        long l2 = range.getStartOffset(l);
        if (l2 < 0L || l2 >= l) {
            return 2;
        }
        return 1;
    }

    public File getSystemFile() {
        return this.partialFile;
    }

    public String toString() {
        return super.toString() + " - Backed SWDownloadFile: " + this.swDownloadFile.toString();
    }

    public void findFittingPartForRange(Range range) {
        Iterator iterator = this.availableRangeSet.getIterator();
        long l = this.getFileSize();
        while (iterator.hasNext()) {
            Range range2 = (Range)iterator.next();
            if (!range2.isRangeSatisfiable(range, l)) continue;
            this.partialFile = this.swDownloadFile.getIncompleteFile();
            long l2 = range.getStartOffset(l);
            long l3 = Math.min(range.getEndOffset(l), range2.getEndOffset(l));
            range.update(l2, l3);
            this.fileStartOffset = l2;
            return;
        }
    }

    public long getFileStartOffset() {
        return this.fileStartOffset;
    }

    public String buildXAvailableRangesString() {
        return this.availableRangeSet.buildXAvailableRangesString();
    }

    public int getFileIndex() {
        throw new UnsupportedOperationException();
    }

    public void setFileIndex(int n) {
        throw new UnsupportedOperationException();
    }

    public Integer getSearchCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getSearchCount() {
        throw new UnsupportedOperationException();
    }

    public void incSearchCount() {
        throw new UnsupportedOperationException();
    }

    public Integer getUploadCountObject() {
        throw new UnsupportedOperationException();
    }

    public int getUploadCount() {
        throw new UnsupportedOperationException();
    }

    public void incUploadCount() {
    }

    public char[] getSearchCompareTerm() {
        throw new UnsupportedOperationException();
    }

    public void updateFromCache(DSharedFile dSharedFile) {
        throw new UnsupportedOperationException();
    }

    public void calculateURN() {
        throw new UnsupportedOperationException();
    }
}

