/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.util.Iterator;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.http.Range;
import phex.net.presentation.PresentationManager;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.share.SharedResource;
import phex.thex.ShareFileThexData;
import phex.utils.NLogger;
import phex.xml.sax.share.DAlternateLocation;
import phex.xml.sax.share.DSharedFile;

public class ShareFile
extends SharedResource {
    private int fileIndex;
    private Long fileSize;
    private URN urn;
    private ShareFileThexData thexData;
    private char[] searchCompareTerm;
    private Integer searchCount;
    private Integer uploadCount;
    private AltLocContainer alternateLocations;
    private Long networkCreateTime;

    public ShareFile(File file) {
        super(file);
        this.fileSize = new Long(this.systemFile.length());
        this.searchCount = new Integer(0);
        this.uploadCount = new Integer(0);
        this.networkCreateTime = new Long(file.lastModified());
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        String string = sharedFilesService.getSharedFilePath(this.systemFile);
        this.searchCompareTerm = string.toLowerCase().toCharArray();
    }

    protected ShareFile(long l) {
        this.fileSize = new Long(l);
    }

    public URN getURN() {
        return this.urn;
    }

    public void setURN(URN uRN) {
        this.urn = uRN;
    }

    public String getSHA1() {
        if (this.urn == null || !this.urn.isSha1Nid()) {
            return "";
        }
        return this.urn.getNamespaceSpecificString();
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(int n) {
        this.fileIndex = n;
    }

    public ShareFileThexData getThexData(boolean bl) {
        if (this.thexData == null && this.urn != null && bl && this.fileSize > 0L) {
            ShareManager.getInstance().getSharedFilesService().queueThexCalculation(this);
        }
        return this.thexData;
    }

    public void setThexData(ShareFileThexData shareFileThexData) {
        this.thexData = shareFileThexData;
    }

    public Long getNetworkCreateTime() {
        return this.networkCreateTime;
    }

    public Long getFileSizeObject() {
        return this.fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public short getRangeAvailableStatus(Range range) {
        long l = this.fileSize;
        long l2 = range.getStartOffset(l);
        if (l2 < 0L || l2 >= l) {
            return 2;
        }
        return 0;
    }

    public AltLocContainer getAltLocContainer() {
        if (this.alternateLocations == null && this.urn != null) {
            this.alternateLocations = new AltLocContainer(this.urn);
        }
        return this.alternateLocations;
    }

    public Integer getSearchCountObject() {
        return this.searchCount;
    }

    public int getSearchCount() {
        return this.searchCount;
    }

    public void incSearchCount() {
        this.searchCount = new Integer(this.searchCount + 1);
    }

    public Integer getUploadCountObject() {
        return this.uploadCount;
    }

    public int getUploadCount() {
        return this.uploadCount;
    }

    public void incUploadCount() {
        this.uploadCount = new Integer(this.uploadCount + 1);
    }

    public char[] getSearchCompareTerm() {
        return this.searchCompareTerm;
    }

    public void updateFromCache(DSharedFile dSharedFile) {
        Object object;
        this.searchCount = new Integer(dSharedFile.getHitCount());
        this.uploadCount = new Integer(dSharedFile.getUploadCount());
        this.urn = new URN("urn:sha1:" + dSharedFile.getSha1());
        this.networkCreateTime = new Long(dSharedFile.getCreationTime());
        String string = dSharedFile.getThexRootHash();
        if (string != null) {
            object = dSharedFile.getThexLowestLevelNodes();
            int n = dSharedFile.getThexTreeDepth();
            if (this.thexData == null) {
                this.thexData = new ShareFileThexData(this, string, (String)object, n);
            } else {
                this.thexData.updateFromCache(string, (String)object, n);
            }
        }
        object = dSharedFile.getAltLocList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            try {
                DAlternateLocation dAlternateLocation = (DAlternateLocation)iterator.next();
                String string2 = dAlternateLocation.getHostAddress();
                String string3 = dAlternateLocation.getUrn();
                if (string3 == null) continue;
                DestAddress destAddress = PresentationManager.getInstance().createHostAddress(string2, 6346);
                AlternateLocation alternateLocation = new AlternateLocation(destAddress, new URN(string3));
                this.getAltLocContainer().addAlternateLocation(alternateLocation);
            }
            catch (Exception exception) {
                NLogger.error("GLOBAL", (Object)"AlternateLocation skipped due to error.", (Throwable)exception);
            }
        }
    }

    public DSharedFile createDSharedFile() {
        DSharedFile dSharedFile = new DSharedFile();
        dSharedFile.setFileName(this.systemFile.getAbsolutePath());
        dSharedFile.setSha1(this.getSHA1());
        if (this.thexData != null) {
            dSharedFile.setThexTreeDepth(this.thexData.getTreeDepth());
            dSharedFile.setThexRootHash(this.thexData.getRootHash());
            dSharedFile.setThexLowestLevelNodes(this.thexData.getXJBLowestLevelNodes());
        }
        dSharedFile.setLastModified(this.systemFile.lastModified());
        dSharedFile.setHitCount(this.searchCount);
        dSharedFile.setUploadCount(this.uploadCount);
        dSharedFile.setCreationTime(this.networkCreateTime);
        if (this.alternateLocations != null) {
            this.alternateLocations.createDAlternateLocationList(dSharedFile.getAltLocList());
        }
        return dSharedFile;
    }

    public String toString() {
        return super.toString() + " " + this.getFileName() + "  " + this.fileIndex;
    }
}

