/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;
import phex.http.HTTPRequest;
import phex.msg.GUID;
import phex.msg.MsgHeader;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.net.connection.Connection;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.SharedFilesService;
import phex.share.export.ExportEngine;
import phex.statistic.MessageCountStatistic;
import phex.upload.UploadManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.SearchEngine;

public class ShareManager
extends AbstractManager {
    private static final ShareFile[] EMPTY_SEARCH_RESULT = new ShareFile[0];
    private static final String INDEX_QUERY_STRING = "    ";
    private SharedFilesService sharedFilesService;

    private ShareManager() {
    }

    public static ShareManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.sharedFilesService = new SharedFilesService();
        return true;
    }

    public boolean onPostInitialization() {
        FileRescanRunner.rescan(true, false);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.getSharedFilesService().triggerSaveSharedFiles();
    }

    public SharedFilesService getSharedFilesService() {
        return this.sharedFilesService;
    }

    public ShareFile[] handleQuery(QueryMsg queryMsg) {
        List list;
        if (queryMsg.getFeatureQuerySelector() > 1) {
            return EMPTY_SEARCH_RESULT;
        }
        if (queryMsg.isRequesterFirewalled() && !NetworkManager.getInstance().hasConnectedIncoming()) {
            return EMPTY_SEARCH_RESULT;
        }
        if (UploadManager.getInstance().isHostBusy()) {
            return EMPTY_SEARCH_RESULT;
        }
        if (queryMsg.isWhatsNewQuery()) {
            return this.sharedFilesService.getNewestFiles(3);
        }
        String string = queryMsg.getSearchString();
        if (string.equals(INDEX_QUERY_STRING)) {
            Logger.logMessage(Logger.FINER, (short)16, "Index query detected.");
            return this.sharedFilesService.getSharedFiles();
        }
        URN[] uRNArray = queryMsg.getQueryURNs();
        if (uRNArray.length > 0) {
            list = this.sharedFilesService.getFilesByURNs(uRNArray);
            if (list.size() == uRNArray.length) {
                return this.provideResultData(list);
            }
        } else {
            list = Collections.EMPTY_LIST;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>(Math.min(10, stringTokenizer.countTokens()));
        while (arrayList.size() < 10 && stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() < 2) continue;
            arrayList.add(string2.toLowerCase());
        }
        if (arrayList.size() == 0) {
            return this.provideResultData(list);
        }
        ShareFile[] shareFileArray = this.sharedFilesService.getSharedFiles();
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<ShareFile> arrayList2 = new ArrayList<ShareFile>(Arrays.asList(shareFileArray));
        for (int i = 0; i < arrayList.size() && arrayList2.size() > 0; ++i) {
            searchEngine.setPattern((String)arrayList.get(i), true);
            for (int j = arrayList2.size() - 1; j >= 0; --j) {
                ShareFile shareFile = arrayList2.get(j);
                if (shareFile.getURN() == null) {
                    arrayList2.remove(j);
                    continue;
                }
                searchEngine.setText(shareFile.getSearchCompareTerm(), true);
                if (searchEngine.match()) continue;
                arrayList2.remove(j);
            }
        }
        if (list.size() > 0) {
            arrayList2.addAll(list);
        }
        return this.provideResultData(arrayList2);
    }

    private ShareFile[] provideResultData(List list) {
        int n = list.size();
        if (n == 0) {
            return EMPTY_SEARCH_RESULT;
        }
        if (n > ServiceManager.sCfg.mUploadMaxSearch) {
            int n2 = n - ServiceManager.sCfg.mUploadMaxSearch;
            list.subList(0, n2).clear();
            n = list.size();
        }
        ShareFile[] shareFileArray = new ShareFile[n];
        shareFileArray = list.toArray(shareFileArray);
        for (int i = 0; i < n; ++i) {
            ShareFile shareFile = shareFileArray[i];
            shareFile.incSearchCount();
        }
        return shareFileArray;
    }

    public void httpRequestHandler(Connection connection, HTTPRequest hTTPRequest) {
        if (hTTPRequest.getRequestMethod().equals("GET") && hTTPRequest.getRequestURI().equals("/")) {
            try {
                this.sendFileListing(hTTPRequest, connection);
            }
            catch (IOException iOException) {
                NLogger.debug(ShareManager.class, (Object)iOException, (Throwable)iOException);
            }
            return;
        }
        this.sendString(connection, this.buildErrorHTTP("404 Not Found", "File not found."));
    }

    private void sendString(Connection connection, String string) {
        try {
            int n;
            byte[] byArray = new byte[string.length()];
            int n2 = IOUtil.serializeString(string, byArray, 0);
            for (int i = 0; i < n2; i += n) {
                n = n2 - i;
                if (n > 1024) {
                    n = 1024;
                }
                connection.write(byArray, i, n);
            }
            connection.flush();
            Thread.sleep(2000L);
            connection.disconnect();
        }
        catch (Exception exception) {
            NLogger.error("GLOBAL", (Object)("Exception whily trying to send sting: '" + string + "'"), (Throwable)exception);
        }
    }

    private String buildErrorHTTP(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<html><head><title>PHEX</title></head><body>");
        stringBuffer.append(string2);
        stringBuffer.append("<hr>Visit the Phex website at ");
        stringBuffer.append("<a href=\"http://phex.sourceforge.net\">http://phex.sourceforge.net</a>.");
        stringBuffer.append("</body>");
        stringBuffer.append("</html>");
        StringBuffer stringBuffer2 = new StringBuffer(300);
        stringBuffer2.append("HTTP/1.1 ").append(string).append("\r\n");
        stringBuffer2.append("Server: ").append(Environment.getPhexVendor()).append("\r\n");
        stringBuffer2.append("Connection: close").append("\r\n");
        stringBuffer2.append("Content-Type: text/plain").append("\r\n");
        stringBuffer2.append("Content-Length: ").append(stringBuffer.length()).append("\r\n");
        stringBuffer2.append("\r\n");
        stringBuffer2.append(stringBuffer.toString());
        return stringBuffer2.toString();
    }

    private void sendFileListing(HTTPRequest hTTPRequest, Connection connection) throws IOException {
        GnutellaOutputStream gnutellaOutputStream = connection.getOutputStream();
        if (!ServiceManager.sCfg.mShareBrowseDir) {
            HTTPHeaderGroup hTTPHeaderGroup = HTTPHeaderGroup.createDefaultResponseHeaders();
            String string = this.createHTTPResponse("403 Browsing disabled", hTTPHeaderGroup);
            connection.write(string.getBytes());
            connection.flush();
            connection.disconnect();
            return;
        }
        HTTPHeader hTTPHeader = hTTPRequest.getHeader("Accept");
        if (hTTPHeader == null) {
            HTTPHeaderGroup hTTPHeaderGroup = HTTPHeaderGroup.createDefaultResponseHeaders();
            String string = this.createHTTPResponse("406 Not Acceptable", hTTPHeaderGroup);
            connection.write(string.getBytes());
            connection.flush();
            connection.disconnect();
            return;
        }
        String string = hTTPHeader.getValue();
        if (string.indexOf("application/x-gnutella-packets") != -1) {
            int n;
            HTTPHeaderGroup hTTPHeaderGroup = HTTPHeaderGroup.createDefaultResponseHeaders();
            hTTPHeaderGroup.addHeader(new HTTPHeader("Content-Type", "application/x-gnutella-packets"));
            hTTPHeaderGroup.addHeader(new HTTPHeader("Connection", "close"));
            String string2 = this.createHTTPResponse("200 OK", hTTPHeaderGroup);
            connection.write(string2.getBytes());
            connection.flush();
            ShareFile[] shareFileArray = this.sharedFilesService.getSharedFiles();
            MsgHeader msgHeader = new MsgHeader(new GUID(), -127, 2, 0, -1);
            for (int i = 0; i < shareFileArray.length; i += n) {
                n = Math.min(255, shareFileArray.length - i);
                QueryResponseRecord[] queryResponseRecordArray = new QueryResponseRecord[n];
                for (int j = 0; j < n; ++j) {
                    QueryResponseRecord queryResponseRecord;
                    ShareFile shareFile = shareFileArray[i + j];
                    queryResponseRecordArray[j] = queryResponseRecord = new QueryResponseRecord(shareFile.getFileIndex(), shareFile.getURN(), (int)shareFile.getFileSize(), shareFile.getFileName(), shareFile.getNetworkCreateTime(), shareFile.getAltLocContainer().getAltLocForQueryResponseRecord());
                }
                DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
                QueryResponseMsg queryResponseMsg = new QueryResponseMsg(msgHeader, ServiceManager.sCfg.mProgramClientID, destAddress, Math.round((long)ServiceManager.sCfg.mUploadMaxBandwidth / 1024L * 8L), queryResponseRecordArray);
                queryResponseMsg.writeMessage(gnutellaOutputStream);
                MessageCountStatistic.queryHitMsgOutCounter.increment(1);
            }
            connection.flush();
        } else if (string.indexOf("text/html") != -1 || string.indexOf("*/*") != -1) {
            HTTPHeaderGroup hTTPHeaderGroup = HTTPHeaderGroup.createDefaultResponseHeaders();
            hTTPHeaderGroup.addHeader(new HTTPHeader("Content-Type", "text/html; charset=iso-8859-1"));
            hTTPHeaderGroup.addHeader(new HTTPHeader("Connection", "close"));
            String string3 = this.createHTTPResponse("200 OK", hTTPHeaderGroup);
            connection.write(string3.getBytes());
            connection.flush();
            this.exportSharedFiles(gnutellaOutputStream);
            connection.flush();
        }
        connection.disconnect();
    }

    private String createHTTPResponse(String string, HTTPHeaderGroup hTTPHeaderGroup) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("HTTP/1.1 ");
        stringBuffer.append(string);
        stringBuffer.append("\r\n");
        stringBuffer.append(hTTPHeaderGroup.buildHTTPHeaderString());
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public void exportSharedFiles(OutputStream outputStream) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/defaultSharedFilesHTMLExport.xsl");
        this.exportSharedFiles(inputStream, outputStream, null);
    }

    public void exportSharedFiles(InputStream inputStream, OutputStream outputStream, Map map) {
        ExportEngine exportEngine = new ExportEngine();
        exportEngine.setExportOptions(map);
        exportEngine.startExport(inputStream, outputStream);
    }

    private static class Holder {
        protected static final ShareManager manager = new ShareManager();

        private Holder() {
        }
    }
}

