/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeMap;
import phex.common.Environment;
import phex.common.RunnerQueueWorker;
import phex.common.ThreadTracking;
import phex.common.URN;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.event.AsynchronousDispatcher;
import phex.event.ShareChangeListener;
import phex.share.FileRescanRunner;
import phex.share.ShareFile;
import phex.share.SharedDirectory;
import phex.share.SharedResource;
import phex.share.UrnCalculationWorker;
import phex.thex.ThexCalculationWorker;
import phex.utils.FileUtils;
import phex.utils.NLogger;
import phex.utils.ReadWriteLock;
import phex.utils.VersionUtils;
import phex.xml.sax.DPhex;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.share.DSharedFile;
import phex.xml.sax.share.DSharedLibrary;

public class SharedFilesService {
    private ReadWriteLock rwLock;
    private HashMap directoryShareMap;
    private ArrayList sharedDirectories;
    private HashMap urnToFileMap;
    private HashMap nameToFileMap;
    private Map timeToFileMap;
    private ArrayList indexedSharedFiles;
    private ArrayList sharedFiles;
    private int totalFileSizeKb;
    private RunnerQueueWorker urnThexCalculationRunner;
    private static Object saveSharedFilesLock;
    private SaveSharedFilesJob saveSharedFilesJob;
    private ArrayList listenerList = new ArrayList(2);
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesService() {
        this.rwLock = new ReadWriteLock();
        this.urnThexCalculationRunner = new RunnerQueueWorker();
        Environment.getInstance().scheduleTimerTask(new FileRescanTimer(), 60000L, 60000L);
        this.directoryShareMap = new HashMap();
        this.sharedDirectories = new ArrayList();
        this.urnToFileMap = new HashMap();
        this.nameToFileMap = new HashMap();
        this.timeToFileMap = new TreeMap(Collections.reverseOrder());
        this.indexedSharedFiles = new ArrayList();
        this.sharedFiles = new ArrayList();
        this.totalFileSizeKb = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSharedFilePath(File file) {
        String string;
        this.rwLock.readLock();
        try {
            Object object;
            File file2;
            File file3 = file.getParentFile();
            Iterator iterator = this.directoryShareMap.keySet().iterator();
            while (iterator.hasNext()) {
                file2 = (File)iterator.next();
                object = (SharedDirectory)this.directoryShareMap.get(file2);
                if (((SharedDirectory)object).getType() != 1 || !FileUtils.isChildOfDir(file, file2) || !FileUtils.isChildOfDir(file3, file2)) continue;
                file3 = file2;
            }
            file2 = file3.getParentFile();
            if (file2 != null) {
                file3 = file2;
            }
            object = file3.getAbsolutePath();
            int n = ((String)object).length();
            if (!((String)object).endsWith(File.separator)) {
                ++n;
            }
            string = file.getAbsolutePath().substring(n);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByName(String string) {
        ShareFile shareFile;
        this.rwLock.readLock();
        try {
            shareFile = (ShareFile)this.nameToFileMap.get(string);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return shareFile;
    }

    public ShareFile getShareFileByFile(File file) {
        return this.getFileByName(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileAt(int n) {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (n < this.sharedFiles.size()) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.sharedFiles.get(n);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile[] getSharedFiles() {
        ShareFile[] shareFileArray;
        this.rwLock.readLock();
        try {
            ShareFile[] shareFileArray2 = new ShareFile[this.sharedFiles.size()];
            shareFileArray = shareFileArray2 = this.sharedFiles.toArray(shareFileArray2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return shareFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCount() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.sharedFiles.size();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalFileSizeInKb() {
        int n;
        this.rwLock.readLock();
        try {
            n = this.totalFileSizeKb;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByIndex(int n) throws IndexOutOfBoundsException {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (n < this.indexedSharedFiles.size()) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.indexedSharedFiles.get(n);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShareFile getFileByURN(URN uRN) throws IndexOutOfBoundsException {
        block7: {
            ShareFile shareFile;
            this.rwLock.readLock();
            try {
                if (uRN != null) break block7;
                shareFile = null;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return shareFile;
        }
        ShareFile shareFile = (ShareFile)this.urnToFileMap.get(uRN);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return shareFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isURNShared(URN uRN) throws IndexOutOfBoundsException {
        block7: {
            boolean bl;
            this.rwLock.readLock();
            try {
                if (uRN != null) break block7;
                bl = false;
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return bl;
        }
        boolean bl = this.urnToFileMap.containsKey(uRN);
        Object var4_5 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilesByURNs(URN[] uRNArray) {
        ArrayList arrayList;
        this.rwLock.readLock();
        try {
            ArrayList arrayList2 = new ArrayList(uRNArray.length);
            for (int i = 0; i < uRNArray.length; ++i) {
                Object v = this.urnToFileMap.get(uRNArray[i]);
                if (v == null) continue;
                arrayList2.add(v);
            }
            arrayList = arrayList2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return arrayList;
    }

    public ShareFile[] getNewestFiles(int n) {
        Object object;
        ArrayList<ShareFile> arrayList = new ArrayList<ShareFile>();
        Iterator iterator = this.timeToFileMap.entrySet().iterator();
        while (iterator.hasNext() && arrayList.size() < n) {
            object = (Set)iterator.next().getValue();
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext() && arrayList.size() < n) {
                ShareFile shareFile = (ShareFile)iterator2.next();
                arrayList.add(shareFile);
            }
        }
        object = new ShareFile[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSharedFile(ShareFile shareFile) {
        File file = shareFile.getSystemFile();
        if (this.getFileByName(file.getAbsolutePath()) != null) {
            return;
        }
        this.rwLock.writeLock();
        try {
            int n = this.indexedSharedFiles.size();
            shareFile.setFileIndex(n);
            this.indexedSharedFiles.add(shareFile);
            this.sharedFiles.add(shareFile);
            this.nameToFileMap.put(file.getAbsolutePath(), shareFile);
            this.totalFileSizeKb = (int)((long)this.totalFileSizeKb + file.length() / 1024L);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimeToFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            Long l = shareFile.getNetworkCreateTime();
            HashSet<ShareFile> hashSet = (HashSet<ShareFile>)this.timeToFileMap.get(l);
            if (hashSet == null) {
                hashSet = new HashSet<ShareFile>();
                this.timeToFileMap.put(l, hashSet);
            }
            hashSet.add(shareFile);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedFile(ShareFile shareFile) {
        this.rwLock.writeLock();
        try {
            int n = shareFile.getFileIndex();
            this.indexedSharedFiles.set(n, null);
            File file = shareFile.getSystemFile();
            this.urnToFileMap.remove(shareFile.getURN());
            this.nameToFileMap.remove(file.getAbsolutePath());
            this.removeTimeToFile(shareFile);
            int n2 = this.sharedFiles.indexOf(shareFile);
            if (n2 != -1) {
                this.sharedFiles.remove(n2);
                this.totalFileSizeKb = (int)((long)this.totalFileSizeKb - shareFile.getFileSize() / 1024L);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void removeTimeToFile(ShareFile shareFile) {
        block8: {
            block6: {
                this.rwLock.writeLock();
                Long l = shareFile.getNetworkCreateTime();
                Set set = (Set)this.timeToFileMap.get(l);
                if (set != null) break block7;
                Object var5_4 = null;
                try {
                    this.rwLock.writeUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                {
                    block7: {
                        return;
                    }
                    set.remove(shareFile);
                    if (set.size() != 0) break block6;
                    this.timeToFileMap.remove(l);
                }
            }
            Object var5_5 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            break block8;
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    this.rwLock.writeUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSharedDirecotries(HashMap hashMap, HashSet hashSet) {
        this.rwLock.writeLock();
        try {
            this.directoryShareMap.clear();
            this.directoryShareMap.putAll(hashMap);
            this.sharedDirectories.clear();
            this.sharedDirectories.addAll(hashSet);
            this.sharedDirectoriesChanged();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory[] getSharedDirectories() {
        SharedDirectory[] sharedDirectoryArray;
        this.rwLock.readLock();
        try {
            SharedDirectory[] sharedDirectoryArray2 = new SharedDirectory[this.sharedDirectories.size()];
            sharedDirectoryArray = sharedDirectoryArray2 = this.sharedDirectories.toArray(sharedDirectoryArray2);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return sharedDirectoryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SharedDirectory getSharedDirectory(File file) {
        block8: {
            SharedDirectory sharedDirectory;
            if (!file.isDirectory()) {
                return null;
            }
            this.rwLock.readLock();
            try {
                SharedResource sharedResource = (SharedResource)this.directoryShareMap.get(file);
                if (!(sharedResource instanceof SharedDirectory)) break block8;
                sharedDirectory = (SharedDirectory)sharedResource;
                Object var5_5 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return sharedDirectory;
        }
        SharedDirectory sharedDirectory = null;
        Object var5_6 = null;
        try {
            this.rwLock.readUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
        return sharedDirectory;
    }

    public void addUrn2FileMapping(ShareFile shareFile) {
        if (!$assertionsDisabled && shareFile.getURN() == null) {
            throw new AssertionError();
        }
        this.urnToFileMap.put(shareFile.getURN(), shareFile);
        this.addTimeToFile(shareFile);
    }

    public void queueUrnCalculation(ShareFile shareFile) {
        UrnCalculationWorker urnCalculationWorker = new UrnCalculationWorker(shareFile);
        this.urnThexCalculationRunner.add(urnCalculationWorker);
    }

    public void queueThexCalculation(ShareFile shareFile) {
        ThexCalculationWorker thexCalculationWorker = new ThexCalculationWorker(shareFile);
        this.urnThexCalculationRunner.add(thexCalculationWorker);
    }

    public void setCalculationRunnerPause(boolean bl) {
        this.urnThexCalculationRunner.setPause(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSharedFiles() {
        this.rwLock.writeLock();
        try {
            this.urnThexCalculationRunner.stopAndClear();
            this.sharedFiles.clear();
            this.indexedSharedFiles.clear();
            this.urnToFileMap.clear();
            this.nameToFileMap.clear();
            this.timeToFileMap.clear();
            this.totalFileSizeKb = 0;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.rwLock.writeUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            throw throwable;
        }
        try {
            this.rwLock.writeUnlock();
        }
        catch (IllegalAccessException illegalAccessException) {
            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSaveSharedFiles() {
        NLogger.debug("Sharing", (Object)"Trigger save shared files...");
        Object object = saveSharedFilesLock;
        synchronized (object) {
            if (this.saveSharedFilesJob != null) {
                this.saveSharedFilesJob.triggerFollowUpSave();
            } else {
                this.saveSharedFilesJob = new SaveSharedFilesJob();
                this.saveSharedFilesJob.start();
            }
        }
    }

    public DSharedLibrary loadSharedLibrary() {
        DPhex dPhex;
        Object object;
        NLogger.debug("Sharing", (Object)"Load shared library configuration file.");
        File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
        try {
            object = FileManager.getInstance().getReadWriteManagedFile(file);
            dPhex = XMLBuilder.loadDPhexFromFile((ManagedFile)object);
            if (dPhex == null) {
                NLogger.debug("Sharing", (Object)"No shared library configuration file found.");
                return null;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            return null;
        }
        catch (IOException iOException) {
            NLogger.error("Sharing", (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{iOException.toString()});
            return null;
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Sharing", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("SharedFilesLoadFailed", new String[]{managedFileException.toString()});
            return null;
        }
        object = dPhex.getSharedLibrary();
        return object;
    }

    public void addSharedFilesChangeListener(ShareChangeListener shareChangeListener) {
        this.listenerList.add(shareChangeListener);
    }

    public void removeSharedFilesChangeListener(ShareChangeListener shareChangeListener) {
        this.listenerList.remove(shareChangeListener);
    }

    private void sharedDirectoriesChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SharedFilesService.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    ShareChangeListener shareChangeListener = (ShareChangeListener)objectArray[i];
                    shareChangeListener.sharedDirectoriesChanged();
                }
            }
        });
    }

    static {
        $assertionsDisabled = !SharedFilesService.class.desiredAssertionStatus();
        saveSharedFilesLock = new Object();
    }

    private class SaveSharedFilesJob
    extends Thread {
        private boolean isFollowUpSaveTriggered;

        public SaveSharedFilesJob() {
            super(ThreadTracking.rootThreadGroup, "SaveSharedFilesJob");
            this.setPriority(1);
        }

        public void triggerFollowUpSave() {
            this.isFollowUpSaveTriggered = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Object object;
            FileManager fileManager = FileManager.getInstance();
            File file = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml");
            File file2 = Environment.getInstance().getPhexConfigFile("sharedlibrary.xml.tmp");
            do {
                NLogger.debug("Sharing", (Object)"Saving shared library.");
                this.isFollowUpSaveTriggered = false;
                SharedFilesService.this.rwLock.readLock();
                object = new DPhex();
                ((DPhex)object).setPhexVersion(VersionUtils.getFullProgramVersion());
                DSharedLibrary dSharedLibrary = this.createDSharedLibrary();
                ((DPhex)object).setSharedLibrary(dSharedLibrary);
                ManagedFile managedFile = fileManager.getReadWriteManagedFile(file2);
                XMLBuilder.saveToFile(managedFile, (DPhex)object);
                ManagedFile managedFile2 = fileManager.getReadWriteManagedFile(file);
                try {
                    managedFile2.acquireFileLock();
                    FileUtils.copyFile(file2, file);
                }
                finally {
                    managedFile2.releaseFileLock();
                }
                Object var10_10 = null;
                try {
                    SharedFilesService.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                continue;
                {
                    catch (ManagedFileException managedFileException) {
                        if (managedFileException.getCause() instanceof InterruptedException) {
                            NLogger.debug("Sharing", (Object)managedFileException);
                        } else {
                            NLogger.error("Sharing", (Object)managedFileException, (Throwable)managedFileException);
                            Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{managedFileException.toString()});
                            NLogger.error("Sharing", (Object)managedFileException, (Throwable)managedFileException);
                        }
                        var10_10 = null;
                        try {
                            SharedFilesService.this.rwLock.readUnlock();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                        }
                        continue;
                    }
                    catch (IOException iOException) {
                        NLogger.error("Sharing", (Object)iOException, (Throwable)iOException);
                        Environment.getInstance().fireDisplayUserMessage("SharedFilesSaveFailed", new String[]{iOException.toString()});
                        var10_10 = null;
                        try {
                            SharedFilesService.this.rwLock.readUnlock();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    try {
                        SharedFilesService.this.rwLock.readUnlock();
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                    }
                    throw throwable;
                }
            } while (this.isFollowUpSaveTriggered);
            NLogger.debug("Sharing", (Object)"Finished saving download list...");
            object = saveSharedFilesLock;
            synchronized (object) {
                SharedFilesService.this.saveSharedFilesJob = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DSharedLibrary createDSharedLibrary() {
            DSharedLibrary dSharedLibrary = new DSharedLibrary();
            SharedFilesService.this.rwLock.readLock();
            try {
                Iterator iterator = SharedFilesService.this.sharedFiles.iterator();
                List list = dSharedLibrary.getSubElementList();
                while (iterator.hasNext()) {
                    try {
                        ShareFile shareFile = (ShareFile)iterator.next();
                        if (shareFile.getURN() == null) continue;
                        DSharedFile dSharedFile = shareFile.createDSharedFile();
                        list.add(dSharedFile);
                    }
                    catch (Exception exception) {
                        NLogger.error("Sharing", (Object)"SharedFile skipped due to error.", (Throwable)exception);
                    }
                }
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    SharedFilesService.this.rwLock.readUnlock();
                }
                catch (IllegalAccessException illegalAccessException) {
                    NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
                }
                throw throwable;
            }
            try {
                SharedFilesService.this.rwLock.readUnlock();
            }
            catch (IllegalAccessException illegalAccessException) {
                NLogger.error("Sharing", (Object)illegalAccessException, (Throwable)illegalAccessException);
            }
            return dSharedLibrary;
        }
    }

    private class FileRescanTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private FileRescanTimer() {
        }

        public void run() {
            try {
                FileRescanRunner.rescan(false, false);
            }
            catch (Throwable throwable) {
                NLogger.error("Sharing", (Object)throwable, throwable);
            }
        }
    }
}

