/*
 * Decompiled with CFR 0.152.
 */
package phex.share;

import com.bitzi.util.Base32;
import com.bitzi.util.SHA1;
import java.io.FileInputStream;
import java.io.IOException;
import phex.common.AltLocContainer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;

class UrnCalculationWorker
implements Runnable {
    private ShareFile shareFile;

    UrnCalculationWorker(ShareFile shareFile) {
        this.shareFile = shareFile;
    }

    public void run() {
        boolean bl = this.calculateURN();
        if (bl) {
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            sharedFilesService.addUrn2FileMapping(this.shareFile);
            sharedFilesService.triggerSaveSharedFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean calculateURN() {
        boolean bl;
        short s = ServiceManager.sCfg.urnCalculationMode;
        FileInputStream fileInputStream = null;
        try {
            SwarmingManager swarmingManager;
            SWDownloadFile sWDownloadFile;
            int n;
            fileInputStream = new FileInputStream(this.shareFile.getSystemFile());
            SHA1 sHA1 = new SHA1();
            byte[] byArray = new byte[65536];
            long l = System.currentTimeMillis();
            long l2 = System.currentTimeMillis();
            while ((n = fileInputStream.read(byArray)) != -1) {
                sHA1.update(byArray, 0, n);
                long l3 = System.currentTimeMillis();
                try {
                    Thread.sleep((l3 - l2) * (long)s);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    boolean bl2 = false;
                    IOUtil.closeQuietly(fileInputStream);
                    return bl2;
                }
                l2 = System.currentTimeMillis();
            }
            fileInputStream.close();
            byte[] byArray2 = sHA1.digest();
            long l4 = System.currentTimeMillis();
            URN uRN = new URN("urn:sha1:" + Base32.encode(byArray2));
            this.shareFile.setURN(uRN);
            if (Logger.isLevelTypeLogged(Logger.FINEST, (short)4)) {
                Logger.logMessage(Logger.FINEST, (short)4, "SHA1 time: " + (l4 - l) + " size: " + this.shareFile.getSystemFile().length());
            }
            if ((sWDownloadFile = (swarmingManager = SwarmingManager.getInstance()).getDownloadFileByURN(uRN)) != null) {
                AltLocContainer altLocContainer = sWDownloadFile.getGoodAltLocContainer();
                this.shareFile.getAltLocContainer().addContainer(altLocContainer);
            }
            bl = true;
        }
        catch (IOException iOException) {
            boolean bl3;
            try {
                NLogger.debug(UrnCalculationWorker.class, (Object)iOException, (Throwable)iOException);
                bl3 = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtil.closeQuietly(fileInputStream);
            return bl3;
        }
        IOUtil.closeQuietly(fileInputStream);
        return bl;
    }
}

