/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.HorizonTracker;
import phex.common.IntObj;
import phex.common.LongObj;
import phex.statistic.StatisticProvider;

public class HorizonStatisticProvider
implements StatisticProvider {
    private static final short HOST_COUNT = 0;
    private static final short FILE_COUNT = 1;
    private static final short FILE_SIZE = 2;
    public static HorizonStatisticProvider HORIZON_HOST_COUNT_PROVIDER = new HorizonStatisticProvider(0);
    public static HorizonStatisticProvider HORIZON_FILE_COUNT_PROVIDER = new HorizonStatisticProvider(1);
    public static HorizonStatisticProvider HORIZON_FILE_SIZE_PROVIDER = new HorizonStatisticProvider(2);
    private short type;
    private LongObj valueObj;
    private IntObj avgObj;

    public HorizonStatisticProvider(short s) {
        this.type = s;
        this.valueObj = new LongObj();
        switch (s) {
            case 1: 
            case 2: {
                this.avgObj = new IntObj();
            }
        }
    }

    public Object getValue() {
        switch (this.type) {
            case 0: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalHostCount();
                break;
            }
            case 1: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalFileCount();
                break;
            }
            case 2: {
                this.valueObj.value = HorizonTracker.getInstance().getTotalFileSize();
            }
        }
        return this.valueObj;
    }

    public Object getAverageValue() {
        switch (this.type) {
            case 2: {
                int n;
                HorizonTracker horizonTracker = HorizonTracker.getInstance();
                long l = horizonTracker.getTotalFileCount();
                if (l == 0L) break;
                this.avgObj.value = n = (int)((double)horizonTracker.getTotalFileSize() / (double)l);
                break;
            }
            case 1: {
                int n;
                HorizonTracker horizonTracker = HorizonTracker.getInstance();
                int n2 = horizonTracker.getTotalHostCount();
                if (n2 == 0) break;
                this.avgObj.value = n = (int)((double)horizonTracker.getTotalFileCount() / (double)n2);
            }
        }
        return this.avgObj;
    }

    public Object getMaxValue() {
        return null;
    }

    public String toStatisticString(Object object) {
        return object.toString();
    }
}

