/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.common.format.TimeFormatUtils;
import phex.statistic.StatisticProvider;

public class UptimeStatisticProvider
implements StatisticProvider {
    private long startTime;
    private LongObj valueObj = new LongObj();
    private LongObj avgObj = new LongObj();
    private LongObj maxObj;

    public UptimeStatisticProvider() {
        this.maxObj = new LongObj(ServiceManager.sCfg.maximalUptime);
        this.startUptimeMeasurement();
    }

    private void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    public Object getValue() {
        long l = System.currentTimeMillis() - this.startTime;
        this.valueObj.setValue(l);
        return this.valueObj;
    }

    public Object getAverageValue() {
        LongObj longObj = (LongObj)this.getValue();
        long l = longObj.longValue();
        l = Math.max(l, 0L);
        long l2 = (l + ServiceManager.sCfg.movingTotalUptime) / (long)(ServiceManager.sCfg.movingTotalUptimeCount + 1);
        this.avgObj.setValue(l2);
        return this.avgObj;
    }

    public Object getMaxValue() {
        long l = System.currentTimeMillis() - this.startTime;
        if (l > this.maxObj.getValue()) {
            this.maxObj.setValue(l);
        }
        return this.maxObj;
    }

    public String toStatisticString(Object object) {
        return TimeFormatUtils.formatSignificantElapsedTime(((LongObj)object).longValue() / 1000L);
    }

    public void saveUptimeStats() {
        LongObj longObj = (LongObj)this.getMaxValue();
        ServiceManager.sCfg.maximalUptime = longObj.getValue();
        if (ServiceManager.sCfg.movingTotalUptimeCount >= 25) {
            ServiceManager.sCfg.movingTotalUptime -= ServiceManager.sCfg.movingTotalUptime / (long)ServiceManager.sCfg.movingTotalUptimeCount;
            --ServiceManager.sCfg.movingTotalUptimeCount;
        }
        if ((longObj = (LongObj)this.getValue()).longValue() > 0L) {
            ServiceManager.sCfg.movingTotalUptime += longObj.longValue();
            ++ServiceManager.sCfg.movingTotalUptimeCount;
        }
    }
}

