/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Base32;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import phex.share.ShareFile;
import phex.thex.TTHashCalcUtils;
import phex.utils.NLogger;

public class ShareFileThexData {
    private ShareFile shareFile;
    private String rootHash;
    private List lowestLevelNodes;
    private int treeDepth;

    public ShareFileThexData(ShareFile shareFile, byte[] byArray, List list, int n) {
        this.shareFile = shareFile;
        this.rootHash = Base32.encode(byArray);
        this.lowestLevelNodes = list;
        this.treeDepth = n;
    }

    public ShareFileThexData(ShareFile shareFile, String string, String string2, int n) {
        this.shareFile = shareFile;
        this.rootHash = string;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(string2);
        this.treeDepth = n;
    }

    public String getRootHash() {
        return this.rootHash;
    }

    public int getTreeDepth() {
        return this.treeDepth;
    }

    public byte[] getSerializedTreeNodes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        List list = TTHashCalcUtils.calculateMerkleParentNodes(this.lowestLevelNodes);
        Iterator iterator = list.iterator();
        try {
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    byteArrayOutputStream.write((byte[])iterator2.next());
                }
            }
        }
        catch (IOException iOException) {
            NLogger.error("GLOBAL", (Object)iOException, (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getXJBLowestLevelNodes() {
        Iterator iterator = this.lowestLevelNodes.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            byte[] byArray = (byte[])iterator.next();
            String string = new String(Base64.encodeBase64(byArray));
            stringBuffer.append(string);
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public void updateFromCache(String string, String string2, int n) {
        this.rootHash = string;
        this.lowestLevelNodes = ShareFileThexData.parseXJBLowestLevelNodes(string2);
        this.treeDepth = n;
    }

    private static List parseXJBLowestLevelNodes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            byte[] byArray = Base64.decodeBase64(string2.getBytes());
            arrayList.add(byArray);
        }
        return arrayList;
    }
}

