/*
 * Decompiled with CFR 0.152.
 */
package phex.thex;

import com.bitzi.util.Tiger;
import com.bitzi.util.TigerTree;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.common.ServiceManager;
import phex.share.ShareFile;
import phex.thex.ShareFileThexData;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class TTHashCalcUtils {
    private static final transient byte MERKLE_IH_PREFIX = 1;
    private static final int THEX_BLOCK_SIZE = 1024;

    public static void calculateShareFileThexData(ShareFile shareFile) throws IOException {
        if (shareFile.getThexData(false) != null) {
            return;
        }
        long l = shareFile.getFileSize();
        int n = TTHashCalcUtils.getTreeLevels(l);
        int n2 = TTHashCalcUtils.getTreeNodeSize(l, n);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(shareFile.getSystemFile()));
        List list = TTHashCalcUtils.calculateTigerTreeNodes(n2, l, bufferedInputStream);
        List list2 = TTHashCalcUtils.calculateMerkleParentNodes(list);
        byte[] byArray = (byte[])((List)list2.get(0)).get(0);
        int n3 = list2.size() - 1;
        ShareFileThexData shareFileThexData = new ShareFileThexData(shareFile, byArray, list, n3);
        shareFile.setThexData(shareFileThexData);
    }

    private static int getTreeLevels(long l) {
        if (l < 262144L) {
            return 0;
        }
        if (l < 524288L) {
            return 1;
        }
        if (l < 0x100000L) {
            return 2;
        }
        if (l < 0x200000L) {
            return 3;
        }
        if (l < 0x400000L) {
            return 4;
        }
        if (l < 0x800000L) {
            return 5;
        }
        if (l < 0x1000000L) {
            return 6;
        }
        if (l < 0x2000000L) {
            return 7;
        }
        if (l < 0x4000000L) {
            return 8;
        }
        if (l < 0x10000000L) {
            return 9;
        }
        if (l < 0x40000000L) {
            return 10;
        }
        return 11;
    }

    private static int getTreeNodeSize(long l, int n) {
        int n2 = (int)Math.pow(2.0, n);
        int n3 = (int)Math.ceil((double)l / (double)n2);
        byte by = IOUtil.calculateCeilLog2(n3);
        int n4 = (int)Math.pow(2.0, by);
        return n4;
    }

    private static List calculateTigerTreeNodes(int n, long l, InputStream inputStream) throws IOException {
        short s = ServiceManager.sCfg.thexCalculationMode;
        int n2 = (int)Math.ceil((double)l / (double)n);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n2);
        TigerTree tigerTree = new TigerTree();
        long l2 = 0L;
        int n3 = 0;
        byte[] byArray = new byte[131072];
        while (l2 < l && n3 != -1) {
            tigerTree.reset();
            int n4 = 0;
            long l3 = System.currentTimeMillis();
            while (n4 < n && (n3 = inputStream.read(byArray)) != -1) {
                tigerTree.update(byArray, 0, n3);
                n4 += n3;
                l2 += (long)n3;
                try {
                    long l4 = System.currentTimeMillis();
                    Thread.sleep((l4 - l3) * (long)s);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Hashing file interrupted.");
                }
                l3 = System.currentTimeMillis();
            }
            arrayList.add(tigerTree.digest());
            if (n3 != -1 || l2 == l) continue;
            NLogger.error("Thex.Calculation", "Hashing file failed.");
            throw new IOException("Hashing file failed.");
        }
        return arrayList;
    }

    public static List calculateMerkleParentNodes(List arrayList) {
        ArrayList<List<Object>> arrayList2 = new ArrayList<List<Object>>();
        arrayList2.add(Collections.unmodifiableList(arrayList));
        ArrayList<byte[]> arrayList3 = arrayList;
        while (arrayList3.size() > 1) {
            Tiger tiger = new Tiger();
            int n = (int)Math.ceil((double)arrayList3.size() / 2.0);
            ArrayList<byte[]> arrayList4 = new ArrayList<byte[]>(n);
            Iterator iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                byte[] byArray = (byte[])iterator.next();
                if (iterator.hasNext()) {
                    byte[] byArray2 = (byte[])iterator.next();
                    tiger.reset();
                    tiger.update((byte)1);
                    tiger.update(byArray, 0, byArray.length);
                    tiger.update(byArray2, 0, byArray2.length);
                    byte[] byArray3 = tiger.digest();
                    arrayList4.add(byArray3);
                    continue;
                }
                arrayList4.add(byArray);
            }
            arrayList2.add(0, arrayList4);
            arrayList3 = arrayList4;
        }
        return arrayList2;
    }
}

