/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.util.Map;
import java.util.TreeMap;
import phex.common.address.DestAddress;
import phex.msg.GUID;

public class UdpGuidRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50;
    protected Map currentMap;
    protected Map lastMap;
    private long lifetime;
    private long nextReplaceTime;

    public UdpGuidRoutingTable(long l) {
        this.lifetime = l;
        this.currentMap = new TreeMap(new GUID.GUIDComparator());
        this.lastMap = new TreeMap(new GUID.GUIDComparator());
    }

    public synchronized boolean checkAndAddRouting(GUID gUID, DestAddress destAddress) {
        this.checkForSwitch();
        if (!this.currentMap.containsKey(gUID) && !this.lastMap.containsKey(gUID)) {
            this.currentMap.put(gUID, destAddress);
            return true;
        }
        return false;
    }

    protected void checkForSwitch() {
        long l = System.currentTimeMillis();
        if (l < this.nextReplaceTime && this.currentMap.size() < 50) {
            return;
        }
        this.lastMap.clear();
        Map map = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = map;
        this.nextReplaceTime = l + this.lifetime;
    }

    public synchronized DestAddress getRouting(GUID gUID) {
        DestAddress destAddress = null;
        destAddress = (DestAddress)this.currentMap.get(gUID);
        if (destAddress != null) {
            return destAddress;
        }
        destAddress = (DestAddress)this.lastMap.get(gUID);
        if (destAddress != null) {
            return destAddress;
        }
        return null;
    }

    public synchronized DestAddress getAndRemoveRouting(GUID gUID) {
        DestAddress destAddress = null;
        destAddress = (DestAddress)this.currentMap.remove(gUID);
        if (destAddress != null) {
            return destAddress;
        }
        destAddress = (DestAddress)this.lastMap.remove(gUID);
        if (destAddress != null) {
            return destAddress;
        }
        return null;
    }
}

