/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import phex.common.PongCache;
import phex.common.ThreadTracking;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.security.PhexSecurityManager;
import phex.udp.UdpGuidRoutingTable;
import phex.udp.UdpMsgQueue;
import phex.utils.NLogger;

public class UdpMessageEngine {
    public static final int MAX_PACKET_SIZE = 1024;
    public static final int MAX_RECV_BUFFER_SIZE = 16384;
    private DatagramSocket udpSocket;
    private UdpMsgQueue sendQueue = new UdpMsgQueue();
    private UdpGuidRoutingTable pingRoutingTable;
    private final HostManager hostMgr;
    private final PhexSecurityManager securityManager = PhexSecurityManager.getInstance();

    public UdpMessageEngine() {
        this.hostMgr = HostManager.getInstance();
        this.pingRoutingTable = new UdpGuidRoutingTable(30000L);
        int n = NetworkManager.getInstance().getLocalAddress().getPort();
        try {
            this.udpSocket = new DatagramSocket(n);
            this.udpSocket.setReceiveBufferSize(16384);
        }
        catch (SocketException socketException) {
            NLogger.warn("UDP_CONNECTION", (Object)(" Couldnt bind to port " + n), (Throwable)socketException);
            return;
        }
        Thread thread = new Thread(ThreadTracking.rootThreadGroup, new Reciever(), "UDP Message Receiver");
        thread.start();
        thread = new Thread(ThreadTracking.rootThreadGroup, new Sender(), "UDP Message Sender");
        thread.start();
    }

    public boolean addMessageToSend(Message message, DestAddress destAddress) {
        if (message == null) {
            return false;
        }
        return this.sendQueue.addMessage(message, destAddress);
    }

    private DatagramPacket getDatagramToSend() {
        Object object;
        Object object2;
        UdpMsgQueue.QueueElement queueElement = this.sendQueue.removeMessage();
        Message message = queueElement.getMsg();
        DestAddress destAddress = queueElement.getAddress();
        byte[] byArray = null;
        if (message instanceof PingMsg) {
            object2 = message.getHeader().getMsgID();
            if (!this.pingRoutingTable.checkAndAddRouting((GUID)object2, destAddress)) {
                NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" ping with duplicate guid not sent " + object2 + " for message : " + message));
                return null;
            }
            object = (PingMsg)message;
            byArray = ((PingMsg)object).getBytes();
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" guid : " + object2 + " successfully added to routing table for " + " udp ping : \n " + message));
        }
        if (message instanceof PongMsg) {
            object2 = (PongMsg)message;
            byArray = ((PongMsg)object2).getbytes();
        }
        if (byArray == null) {
            return null;
        }
        try {
            object = destAddress.getIpAddress();
            object2 = object != null ? InetAddress.getByAddress(((IpAddress)object).getHostIP()) : InetAddress.getByName(destAddress.getHostName());
            int n = destAddress.getPort();
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, (InetAddress)object2, n);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" created udp datagram for msg " + message + " \n to " + object2));
            return datagramPacket;
        }
        catch (UnknownHostException unknownHostException) {
            NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)(" Could not create datagram  from message : " + message), (Throwable)unknownHostException);
            return null;
        }
    }

    public DatagramPacket readMessage() {
        byte[] byArray = new byte[1024];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            this.udpSocket.receive(datagramPacket);
            return datagramPacket;
        }
        catch (IOException iOException) {
            NLogger.warn("UDP_CONNECTION", (Object)(" Could not read from udp socket " + this.udpSocket.getLocalSocketAddress()), (Throwable)iOException);
            return null;
        }
    }

    private void handlePing(MsgHeader msgHeader, byte[] byArray, Host host) {
        PingMsg pingMsg = null;
        try {
            pingMsg = PingMsg.createUdpPingMsg(msgHeader, byArray, 23, host);
            NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Ping Msg From " + host + " : " + pingMsg));
        }
        catch (InvalidMessageException invalidMessageException) {
            return;
        }
        this.respondToPing(pingMsg);
    }

    private void respondToPing(PingMsg pingMsg) {
        PongMsg pongMsg = PongMsg.createUdpPongMsg(pingMsg);
        DestAddress destAddress = pingMsg.getHeader().getFromHost().getHostAddress();
        this.addMessageToSend(pongMsg, destAddress);
        NLogger.info("UDP_OUTGOING_MESSAGES", (Object)("added to send queue Udp Pong :" + pongMsg + " \n \t to " + destAddress));
    }

    private void handlePong(MsgHeader msgHeader, byte[] byArray, Host host) {
        boolean bl;
        GUID gUID = msgHeader.getMsgID();
        DestAddress destAddress = this.pingRoutingTable.getAndRemoveRouting(gUID);
        if (destAddress == null) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Pong  with Guid not found in the routing table : " + msgHeader + " \n \t Ignoring pong"));
            return;
        }
        PongMsg pongMsg = null;
        try {
            pongMsg = PongMsg.createUdpPongMsg(msgHeader, byArray, 23, host);
            NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recieved Udp Pong Msg From " + host + " : " + pongMsg));
        }
        catch (InvalidMessageException invalidMessageException) {
            return;
        }
        byte[] byArray2 = pongMsg.getIP();
        byte by = this.securityManager.controlHostIPAccess(byArray2);
        if (by == 3) {
            return;
        }
        if (by == 1 && (bl = this.hostMgr.getCaughtHostsContainer().addCaughtHost(pongMsg))) {
            PongCache.getInstance().addPong(pongMsg);
        }
    }

    class Reciever
    implements Runnable {
        Reciever() {
        }

        public void run() {
            block6: while (true) {
                DatagramPacket datagramPacket;
                if ((datagramPacket = UdpMessageEngine.this.readMessage()) == null) {
                    continue;
                }
                byte[] byArray = datagramPacket.getData();
                int n = datagramPacket.getLength();
                byte[] byArray2 = datagramPacket.getAddress().getAddress();
                int n2 = datagramPacket.getPort();
                DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray2, n2);
                if (n < 23) continue;
                Host host = UdpMessageEngine.this.hostMgr.getNetworkHostsContainer().getNetworkHost(defaultDestAddress);
                if (host == null) {
                    host = new Host(defaultDestAddress);
                }
                MsgHeader msgHeader = null;
                try {
                    msgHeader = MsgHeader.createMsgHeader(byArray, 0);
                }
                catch (Exception exception) {
                    NLogger.warn("UDP_INCOMING_MESSAGES", (Object)" Failed to create udp pong from datagram ", (Throwable)exception);
                }
                if (msgHeader.getDataLength() > n - 23) {
                    NLogger.warn("UDP_INCOMING_MESSAGES", (Object)" Msg Header Data length is invalid ");
                }
                switch (msgHeader.getPayload()) {
                    case 0: {
                        NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd Ping from : " + defaultDestAddress));
                        UdpMessageEngine.this.handlePing(msgHeader, byArray, host);
                        continue block6;
                    }
                    case 1: {
                        NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd Pong from : " + defaultDestAddress));
                        UdpMessageEngine.this.handlePong(msgHeader, byArray, host);
                        continue block6;
                    }
                }
                NLogger.debug("UDP_INCOMING_MESSAGES", (Object)(" Recvd unrecognized Msg from : " + defaultDestAddress));
            }
        }
    }

    private class Sender
    implements Runnable {
        private Sender() {
        }

        public void run() {
            while (true) {
                DatagramPacket datagramPacket;
                if ((datagramPacket = UdpMessageEngine.this.getDatagramToSend()) == null) {
                    continue;
                }
                try {
                    UdpMessageEngine.this.udpSocket.send(datagramPacket);
                    continue;
                }
                catch (IOException iOException) {
                    NLogger.warn("UDP_OUTGOING_MESSAGES", (Object)("Sending udp message " + datagramPacket + "failed "), (Throwable)iOException);
                    continue;
                }
                break;
            }
        }
    }
}

