/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.SystemUtils;
import phex.common.URN;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;

public class UpdateDownloader {
    public static void createUpdateDownload() throws URIException {
        String string = SystemUtils.IS_OS_MAC_OSX ? "magnet:?xs=http://draketo.de/dateien/phex_osx.magma&dn=phex_osx.magma" : (SystemUtils.IS_OS_WINDOWS ? "magnet:?xs=http://draketo.de/dateien/phex_win.magma&dn=phex_win.magma" : "magnet:?xs=http://draketo.de/dateien/phex_other.magma&dn=phex_other.magma");
        UpdateDownloader.createDownload(string);
    }

    private static void createDownload(String string) throws URIException {
        if (string.length() == 0) {
            return;
        }
        URI uRI = new URI(string, true);
        MagnetData magnetData = MagnetData.parseFromURI(uRI);
        URN uRN = MagnetData.lookupSHA1URN(magnetData);
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        if (!swarmingManager.isURNDownloaded(uRN)) {
            swarmingManager.addFileToDownload(uRI);
        }
    }
}

