/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import phex.common.bandwidth.BandwidthController;
import phex.utils.NLogger;

public class BandwidthInputStream
extends InputStream {
    private InputStream inStream;
    private BandwidthController bandwidthController;

    public BandwidthInputStream(InputStream inputStream, BandwidthController bandwidthController) {
        this.inStream = inputStream;
        this.bandwidthController = bandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    public int read() throws IOException {
        this.bandwidthController.getAvailableByteCount(true);
        int n = this.inStream.read();
        this.bandwidthController.markBytesUsed(1);
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.bandwidthController.getAvailableByteCount(n2, true);
        try {
            int n4 = this.inStream.read(byArray, n, n3);
            this.bandwidthController.markBytesUsed(n4);
            return n4;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            NLogger.error("BANDWIDTH", (Object)arrayIndexOutOfBoundsException, (Throwable)arrayIndexOutOfBoundsException);
            NLogger.error("BANDWIDTH", "buffer:" + byArray.length + " off " + n + " len " + n2 + " avail " + n3);
            return 0;
        }
    }

    public int available() throws IOException {
        return this.inStream.available();
    }

    public void close() throws IOException {
        this.inStream.close();
    }
}

