/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.OutputStream;
import phex.common.bandwidth.BandwidthController;

public class BandwidthOutputStream
extends OutputStream {
    private OutputStream outStream;
    private BandwidthController bandwidthController;

    public BandwidthOutputStream(OutputStream outputStream, BandwidthController bandwidthController) {
        this.outStream = outputStream;
        this.bandwidthController = bandwidthController;
    }

    public void setBandwidthController(BandwidthController bandwidthController) {
        this.bandwidthController = bandwidthController;
    }

    public void write(int n) throws IOException {
        this.bandwidthController.getAvailableByteCount(true);
        this.outStream.write(n);
        this.bandwidthController.markBytesUsed(1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = this.bandwidthController.getAvailableByteCount(n2, true);
            this.outStream.write(byArray, n, n3);
            this.bandwidthController.markBytesUsed(n3);
            n2 -= n3;
            n += n3;
        }
    }

    public void flush() throws IOException {
        this.outStream.flush();
    }

    public void close() throws IOException {
        this.outStream.flush();
    }
}

