/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.nio.ByteBuffer;
import phex.msg.GUID;
import phex.utils.DirectByteBufferProvider;

public class DirectByteBuffer {
    private ByteBuffer buffer;
    private DirectByteBufferProvider provider;
    private String id;

    public DirectByteBuffer(ByteBuffer byteBuffer, DirectByteBufferProvider directByteBufferProvider) {
        this.buffer = byteBuffer;
        this.provider = directByteBufferProvider;
        this.id = new GUID().toString();
    }

    public ByteBuffer getInternalBuffer() {
        return this.buffer;
    }

    public void release() {
        this.provider.releaseDirectByteBuffer(this);
    }

    public void put(byte[] byArray, int n, int n2) {
        this.buffer.put(byArray, n, n2);
    }

    public void flip() {
        this.buffer.flip();
    }

    public void clear() {
        this.buffer.clear();
    }

    public final int limit() {
        return this.buffer.limit();
    }

    public String toString() {
        return "DByteBuffer:[ID:" + this.id + ", " + super.toString() + "]";
    }

    public boolean isEqual(Object object) {
        if (!(object instanceof DirectByteBuffer)) {
            return false;
        }
        return this.id.equals(this.id);
    }

    public int hashCode() {
        int n = this.id.hashCode();
        int n2 = 31 * n + n;
        return n2;
    }
}

