/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import phex.common.FileHandlingException;
import phex.utils.IOUtil;

public final class FileUtils {
    private static final int BUFFER_LENGTH = 262144;

    private FileUtils() {
    }

    public static String getFileExtension(File file) {
        String string = file.getName();
        return FileUtils.getFileExtension(string);
    }

    public static String getFileExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static String replaceFileExtension(String string, String string2) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string + "." + string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    public static String convertToLocalSystemFilename(String string) {
        string = string.replace('/', '_');
        return string.substring(0, Math.min(255, string.length()));
    }

    /*
     * Exception decompiling
     */
    public static void appendFile(File var0, File var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileUtils.copyFile(file, file2, file.length());
        if (file.length() != file2.length()) {
            String string = "Failed to copy full contents from " + file + " to " + file2 + " - " + file.length() + "/" + file2.length();
            throw new IOException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, long l) throws IOException {
        if (!file.exists()) {
            String string = "File " + file + " does not exist";
            throw new FileNotFoundException(string);
        }
        if (file2.getParentFile() != null && !file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (file2.exists() && !file2.canWrite()) {
            String string = "Unable to open file " + file2 + " for writing.";
            throw new IOException(string);
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            String string = "Unable to write file " + file + " on itself.";
            throw new IOException(string);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int n;
            long l2;
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[(int)Math.min(262144L, l2 + 1L)];
            for (l2 = l; l2 > 0L && (n = fileInputStream.read(byArray)) != -1; l2 -= (long)n) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(fileInputStream);
            IOUtil.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtil.closeQuietly(fileInputStream);
        IOUtil.closeQuietly(fileOutputStream);
        file2.setLastModified(file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitFile(File file, File file2, long l) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            try {
                int n;
                randomAccessFile.seek(l);
                byte[] byArray = new byte[(int)Math.min(262144L, file.length() + 1L)];
                while (-1 != (n = randomAccessFile.read(byArray))) {
                    fileOutputStream.write(byArray, 0, n);
                }
                randomAccessFile.setLength(l);
            }
            finally {
                IOUtil.closeQuietly(fileOutputStream);
            }
        }
        finally {
            IOUtil.closeQuietly(randomAccessFile);
        }
    }

    public static void renameLocalFile(File file, File file2) throws FileHandlingException {
        if (file2.exists()) {
            throw new FileHandlingException(1);
        }
        if (file.exists() && !file.renameTo(file2)) {
            throw new FileHandlingException(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateFile(File file, long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("File size < 0: " + l);
        }
        if (file.exists() && file.length() > l) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            try {
                randomAccessFile.setLength(l);
            }
            finally {
                IOUtil.closeQuietly(randomAccessFile);
            }
        }
    }

    public static boolean isChildOfDir(File file, File file2) {
        if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) {
            return false;
        }
        return FileUtils.isChildOfDirInternal(file, file2);
    }

    private static boolean isChildOfDirInternal(File file, File file2) {
        File file3 = file.getParentFile();
        if (file3 == null) {
            return false;
        }
        if (file3.equals(file2)) {
            return true;
        }
        return FileUtils.isChildOfDirInternal(file3, file2);
    }
}

