/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

public final class HexConverter {
    private static final char[] hexValueArray = new char[16];

    public static final String toHexString(byte[] byArray) {
        return HexConverter.toHexString(byArray, 0, byArray.length);
    }

    public static final String toHexString(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Length " + n2 + " < 0 ");
        }
        int n3 = n + n2;
        if (n > byArray.length || n3 > byArray.length) {
            throw new IndexOutOfBoundsException("Data length: " + byArray.length + " offset: " + n + " length: " + n2);
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * 2);
        for (int i = n; i < n3; ++i) {
            stringBuffer.append(hexValueArray[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexValueArray[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public static final String toHexString(byte by) {
        StringBuffer stringBuffer = new StringBuffer(2);
        stringBuffer.append(hexValueArray[by >> 4 & 0xF]);
        stringBuffer.append(hexValueArray[by & 0xF]);
        return stringBuffer.toString();
    }

    public static final byte[] toBytes(String string) {
        if (string == null) {
            throw new NullPointerException("HexString is null");
        }
        int n = string.length();
        if (n % 2 != 0) {
            throw new NumberFormatException("Hex string has odd characters: " + string);
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by;
            byte by2;
            char c = string.charAt(n2);
            if (c >= '0' && c <= '9') {
                by2 = (byte)(c - 48);
            } else if (c >= 'A' && c <= 'F') {
                by2 = (byte)(10 + c - 65);
            } else if (c >= 'a' && c <= 'f') {
                by2 = (byte)(10 + c - 97);
            } else {
                throw new NumberFormatException("Invalid hex char: " + c);
            }
            char c2 = string.charAt(n2 + 1);
            if (c2 >= '0' && c2 <= '9') {
                by = (byte)(c2 - 48);
            } else if (c2 >= 'A' && c2 <= 'F') {
                by = (byte)(10 + c2 - 65);
            } else if (c2 >= 'a' && c2 <= 'f') {
                by = (byte)(10 + c2 - 97);
            } else {
                throw new NumberFormatException("Invalid hex char: " + c2);
            }
            byArray[n3] = (byte)(by2 << 4 | by);
            n2 += 2;
            ++n3;
        }
        return byArray;
    }

    static {
        HexConverter.hexValueArray[0] = 48;
        HexConverter.hexValueArray[1] = 49;
        HexConverter.hexValueArray[2] = 50;
        HexConverter.hexValueArray[3] = 51;
        HexConverter.hexValueArray[4] = 52;
        HexConverter.hexValueArray[5] = 53;
        HexConverter.hexValueArray[6] = 54;
        HexConverter.hexValueArray[7] = 55;
        HexConverter.hexValueArray[8] = 56;
        HexConverter.hexValueArray[9] = 57;
        HexConverter.hexValueArray[10] = 65;
        HexConverter.hexValueArray[11] = 66;
        HexConverter.hexValueArray[12] = 67;
        HexConverter.hexValueArray[13] = 68;
        HexConverter.hexValueArray[14] = 69;
        HexConverter.hexValueArray[15] = 70;
    }
}

