/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import phex.common.ServiceManager;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public final class Logger {
    public static final LogLevel FINEST = new LogLevel(0);
    public static final LogLevel FINER = new LogLevel(1);
    public static final LogLevel FINE = new LogLevel(2);
    public static final LogLevel CONFIG = new LogLevel(3);
    public static final LogLevel INFO = new LogLevel(4);
    public static final LogLevel WARNING = new LogLevel(5);
    public static final LogLevel SEVERE = new LogLevel(6);
    public static final short GLOBAL = 255;
    public static final short DOWNLOAD = 2;
    public static final short UPLOAD = 4;
    public static final short SEARCH = 8;
    public static final short NETWORK = 16;
    public static final short GUI = 32;
    public static final short PERFORMANCE = 64;
    public static final short DOWNLOAD_NET = 128;
    private static short logLevelValue = Logger.SEVERE.value;
    private static short logType = 1;
    private static Map logResourceMap = new HashMap();

    private Logger() {
    }

    public static void logMessage(LogLevel logLevel, short s, Object object) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        Object[] objectArray = new Object[]{object};
        Logger.logMessage(logLevel, s, "log.core.msg", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, Throwable throwable) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        String string = Logger.getStackTrace(throwable);
        Object[] objectArray = new Object[]{string};
        Logger.logMessage(logLevel, s, "log.core.exp", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, Object object, Object object2) {
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        Object[] objectArray = new Object[]{object, object2};
        Logger.logMessage(logLevel, s, "log.core.msg2", objectArray);
    }

    public static void logMessage(LogLevel logLevel, short s, String string, Object[] objectArray) {
        String string2;
        if (logLevelValue > logLevel.value || (s & logType) == 0) {
            return;
        }
        String string3 = string != null ? ((string2 = (String)logResourceMap.get(string)) != null ? MessageFormat.format(string2, objectArray) : string2) : StringUtils.join(objectArray, ";");
        string2 = Logger.getLogTypeName(s);
        string3 = "(" + string2 + ")! " + string3;
        switch (logLevel.value) {
            case 0: 
            case 1: 
            case 2: {
                NLogger.debug(string2, (Object)string3);
                break;
            }
            case 3: 
            case 4: {
                NLogger.info(string2, (Object)string3);
                break;
            }
            case 5: {
                NLogger.warn(string2, (Object)string3);
                break;
            }
            case 6: {
                NLogger.error(string2, string3);
            }
        }
    }

    public static void setVerboseLevel(short s) {
        if (s >= Logger.FINEST.value && s <= Logger.SEVERE.value) {
            logLevelValue = s;
        }
    }

    public static int getVerboseLevel() {
        return logLevelValue;
    }

    public static void setLogType(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        logType = (short)(1 | (bl ? 2 : 0) | (bl2 ? 4 : 0) | (bl3 ? 8 : 0) | (bl4 ? 16 : 0) | (bl5 ? 32 : 0));
    }

    public static void setLogType(short s) {
        if (s >= 1 && s <= 255) {
            logType = s;
        }
    }

    public static boolean isTypeLogged(short s) {
        return (s & logType) > 0;
    }

    public static boolean isLevelLogged(LogLevel logLevel) {
        return logLevelValue <= logLevel.value;
    }

    public static boolean isLevelTypeLogged(LogLevel logLevel, short s) {
        if (logLevelValue > logLevel.value) {
            return false;
        }
        return (s & logType) > 0;
    }

    private static String getLogTypeName(short s) {
        switch (s) {
            case 2: {
                return "Download";
            }
            case 4: {
                return "Upload";
            }
            case 8: {
                return "Search";
            }
            case 16: {
                return "Network";
            }
            case 32: {
                return "GUI";
            }
            case 64: {
                return "Performance";
            }
            case 128: {
                return "Download Net";
            }
            case 255: {
                return "Global";
            }
        }
        return "Unknwon (" + s + ')';
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        while (throwable != null) {
            throwable.printStackTrace(printWriter);
            if (throwable instanceof InvocationTargetException) {
                throwable = ((InvocationTargetException)throwable).getTargetException();
                continue;
            }
            throwable = null;
        }
        return charArrayWriter.toString();
    }

    static {
        logResourceMap.put("log.core.msg", "{0}");
        logResourceMap.put("log.core.msg2", "{0} {1}");
        logResourceMap.put("log.core.exp", "Exception occured: {0}");
        logResourceMap.put("log.core.expmsg", "{1} - Exception: {0}");
        Logger.setVerboseLevel(ServiceManager.sCfg.loggerVerboseLevel);
        Logger.setLogType(ServiceManager.sCfg.logType);
    }

    public static final class LogLevel {
        public final short value;

        public LogLevel(short s) {
            this.value = s;
        }
    }
}

