/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MagmaParser {
    public String uuri;
    private static final String EOL_CHARACTERS = "\r\n";
    private static final char[] MAGMA_LINE;
    private static final char[] MAGNET_PREFIX;
    private static final char[] LIST_ELEMENT;
    private PushbackReader reader;
    private ArrayList magnets;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MagmaParser(InputStream inputStream) {
        block2: {
            this.magnets = new ArrayList();
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                this.reader = new PushbackReader(inputStreamReader, 6);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        try {
            int n;
            char[] cArray = new char[6];
            for (int i = 0; i != 6; i += n) {
                n = this.reader.read(cArray, i, 6);
                if (n != -1) continue;
                throw new IOException("Input file is no MAGMA-File (" + String.valueOf(cArray) + ").");
            }
            if (Arrays.equals(cArray, MAGMA_LINE)) {
                this.skipToEOL();
                this.parseList();
            }
        }
        finally {
            this.reader.close();
        }
    }

    public List getMagnets() {
        return this.magnets;
    }

    private void parseList() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.reader.read()) == LIST_ELEMENT[n]) {
                if (++n != LIST_ELEMENT.length) continue;
                this.skipToEOL();
                this.parseListBody();
                n = 0;
                continue;
            }
            if (n2 == -1) {
                return;
            }
            n = 0;
            this.skipToEOL();
        }
    }

    private void parseListBody() throws IOException {
        boolean bl = true;
        while (true) {
            int n;
            if ((n = this.reader.read()) == 45) {
                if (!bl) {
                    this.parseListElement();
                    continue;
                }
                int n2 = this.reader.read();
                if (n2 == 32) {
                    this.reader.unread(n2);
                    this.parseListElement();
                    continue;
                }
                this.reader.unread(n2);
                this.reader.unread(n);
                return;
            }
            if (n == 35) {
                this.skipToEOL();
                bl = true;
                continue;
            }
            if (n == 32 || n == 13 || n == 10) {
                bl = false;
                continue;
            }
            if (EOL_CHARACTERS.indexOf(n) != -1) {
                bl = true;
                continue;
            }
            if (n == -1) {
                return;
            }
            if (bl) {
                this.reader.unread(n);
                return;
            }
            this.skipToEOL();
            bl = true;
        }
    }

    private void parseListElement() throws IOException {
        int n;
        while (true) {
            if ((n = this.reader.read()) == 32) {
                continue;
            }
            if (n != 35) break;
            this.skipToEOL();
        }
        if (n == 34) {
            int n2;
            char[] cArray = new char[6];
            for (int i = 0; i != 6; i += n2) {
                n2 = this.reader.read(cArray, i, 6);
                if (n2 != -1) continue;
                return;
            }
            this.reader.unread(cArray);
            if (Arrays.equals(cArray, MAGNET_PREFIX)) {
                this.parseMagnet();
            } else {
                this.skipToEOL();
            }
            return;
        }
        if (n == -1) {
            return;
        }
        this.skipToEOL();
    }

    private void parseMagnet() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.reader.read()) == 32 || EOL_CHARACTERS.indexOf(n) != -1) {
                continue;
            }
            if (n == 34) break;
            if (n == -1) {
                return;
            }
            stringBuffer.append((char)n);
        }
        this.magnets.add(stringBuffer.toString());
    }

    private void skipToEOL() throws IOException {
        int n;
        do {
            if ((n = this.reader.read()) >= 0) continue;
            return;
        } while (EOL_CHARACTERS.indexOf(n) == -1);
        while (EOL_CHARACTERS.indexOf(n) != -1) {
            n = this.reader.read();
        }
        this.reader.unread(n);
    }

    static {
        $assertionsDisabled = !MagmaParser.class.desiredAssertionStatus();
        MAGMA_LINE = new char[]{'#', 'M', 'A', 'G', 'M', 'A'};
        MAGNET_PREFIX = new char[]{'m', 'a', 'g', 'n', 'e', 't'};
        LIST_ELEMENT = new char[]{'l', 'i', 's', 't', ':'};
    }
}

