/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import phex.common.Environment;
import phex.utils.IOUtil;

public class NLogger {
    public static final short LOG_LEVEL_DEBUG = 1;
    public static final short LOG_LEVEL_INFO = 2;
    public static final short LOG_LEVEL_WARN = 3;
    public static final short LOG_LEVEL_ERROR = 4;
    private static LogFactory factory;

    public static Log getLogInstance(String string) {
        try {
            return factory.getInstance(string);
        }
        catch (LogConfigurationException logConfigurationException) {
            Properties properties = System.getProperties();
            properties.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            LogFactory.releaseAll();
            factory = LogFactory.getFactory();
            return factory.getInstance(string);
        }
    }

    public static Log getLogInstance(Class clazz) {
        try {
            return factory.getInstance(clazz);
        }
        catch (LogConfigurationException logConfigurationException) {
            Properties properties = System.getProperties();
            properties.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            LogFactory.releaseAll();
            factory = LogFactory.getFactory();
            return factory.getInstance(clazz);
        }
    }

    public static boolean isDebugEnabled(String string) {
        return NLogger.getLogInstance(string).isDebugEnabled();
    }

    public static boolean isDebugEnabled(Class clazz) {
        return NLogger.getLogInstance(clazz).isDebugEnabled();
    }

    public static boolean isInfoEnabled(String string) {
        return NLogger.getLogInstance(string).isInfoEnabled();
    }

    public static boolean isWarnEnabled(String string) {
        return NLogger.getLogInstance(string).isWarnEnabled();
    }

    public static boolean isWarnEnabled(Class clazz) {
        return NLogger.getLogInstance(clazz).isWarnEnabled();
    }

    public static boolean isErrorEnabled(String string) {
        return NLogger.getLogInstance(string).isErrorEnabled();
    }

    public static boolean isEnabled(short s, String string) {
        switch (s) {
            case 1: {
                return NLogger.isDebugEnabled(string);
            }
            case 2: {
                return NLogger.isInfoEnabled(string);
            }
            case 3: {
                return NLogger.isWarnEnabled(string);
            }
            case 4: {
                return NLogger.isErrorEnabled(string);
            }
        }
        throw new IllegalArgumentException("Unknown log level: " + s);
    }

    public static void debug(String string, Object object) {
        NLogger.getLogInstance(string).debug(object);
    }

    public static void debug(Class clazz, Object object) {
        NLogger.getLogInstance(clazz).debug(object);
    }

    public static void debug(String string, Object object, Throwable throwable) {
        NLogger.getLogInstance(string).debug(object, throwable);
    }

    public static void debug(Class clazz, Object object, Throwable throwable) {
        NLogger.getLogInstance(clazz).debug(object, throwable);
    }

    public static void info(String string, Object object) {
        NLogger.getLogInstance(string).info(object);
    }

    public static void info(Class clazz, Object object) {
        NLogger.getLogInstance(clazz).info(object);
    }

    public static void info(String string, Object object, Throwable throwable) {
        NLogger.getLogInstance(string).info(object, throwable);
    }

    public static void warn(String string, Object object) {
        NLogger.getLogInstance(string).warn(object);
    }

    public static void warn(String string, Object object, Throwable throwable) {
        NLogger.getLogInstance(string).warn(object, throwable);
    }

    public static void warn(Class clazz, Object object, Throwable throwable) {
        NLogger.getLogInstance(clazz).warn(object, throwable);
    }

    public static void warn(Class clazz, Object object) {
        NLogger.getLogInstance(clazz).warn(object);
    }

    public static void error(String string, Object object) {
        NLogger.getLogInstance(string).error(object);
    }

    public static void error(String string, Object object, Throwable throwable) {
        NLogger.getLogInstance(string).error(object, throwable);
    }

    public static void error(Class clazz, Object object, Throwable throwable) {
        NLogger.getLogInstance(clazz).error(object, throwable);
    }

    public static void log(short s, String string, Object object, Throwable throwable) {
        switch (s) {
            case 1: {
                NLogger.debug(string, object, throwable);
                break;
            }
            case 2: {
                NLogger.info(string, object, throwable);
                break;
            }
            case 3: {
                NLogger.warn(string, object, throwable);
                break;
            }
            case 4: {
                NLogger.error(string, object, throwable);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown log level: " + s);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        InputStream inputStream;
        Properties properties;
        Properties properties2;
        block10: {
            properties2 = System.getProperties();
            properties2.put("org.apache.commons.logging.Log", "phex.utils.PhexLogger");
            factory = LogFactory.getFactory();
            properties = new Properties();
            inputStream = null;
            try {
                object = Thread.currentThread().getContextClassLoader();
                inputStream = ((ClassLoader)object).getResourceAsStream("phex/resources/logging.properties");
                if (inputStream == null) break block10;
                properties.load(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace();
                }
                catch (Throwable throwable2) {
                    IOUtil.closeQuietly(inputStream);
                    throw throwable2;
                }
                IOUtil.closeQuietly(inputStream);
            }
        }
        IOUtil.closeQuietly(inputStream);
        object = null;
        try {
            File file = Environment.getInstance().getPhexConfigFile("logging.properties");
            if (file.exists()) {
                object = new BufferedInputStream(new FileInputStream(file));
                properties.load((InputStream)object);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            IOUtil.closeQuietly((InputStream)object);
        }
        properties2 = System.getProperties();
        properties2.putAll((Map<?, ?>)properties);
        LogFactory.releaseAll();
        factory = LogFactory.getFactory();
    }
}

