/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.Serializable;
import java.net.MalformedURLException;

public final class NormalizableURL
implements Serializable {
    private String authority = null;
    private String file = null;
    private String host = null;
    private String path = null;
    private int port = -1;
    private String protocol = null;
    private String query = null;
    private String ref = null;
    private String userInfo = null;

    public NormalizableURL(String string) throws MalformedURLException {
        this(null, string);
    }

    public NormalizableURL(NormalizableURL normalizableURL, String string) throws MalformedURLException {
        String string2 = string;
        int n = 0;
        String string3 = null;
        boolean bl = false;
        try {
            int n2;
            int n3;
            for (n3 = string.length(); n3 > 0 && string.charAt(n3 - 1) <= ' '; --n3) {
            }
            while (n < n3 && string.charAt(n) <= ' ') {
                ++n;
            }
            if (string.regionMatches(true, n, "url:", 0, 4)) {
                n += 4;
            }
            if (n < string.length() && string.charAt(n) == '#') {
                bl = true;
            }
            for (n2 = n; !bl && n2 < n3; ++n2) {
                char c = string.charAt(n2);
                if (c == ':') {
                    String string4;
                    string3 = string4 = string.substring(n, n2).toLowerCase();
                    n = n2 + 1;
                    break;
                }
                if (c == '#') {
                    bl = true;
                    continue;
                }
                if (!NormalizableURL.isSchemeChar(c)) break;
            }
            this.protocol = string3;
            if (normalizableURL != null && (string3 == null || string3.equalsIgnoreCase(normalizableURL.getProtocol()))) {
                if (normalizableURL.getPath() != null && normalizableURL.getPath().startsWith("/")) {
                    string3 = null;
                }
                if (string3 == null) {
                    this.protocol = normalizableURL.getProtocol();
                    this.authority = normalizableURL.getAuthority();
                    this.userInfo = normalizableURL.getUserInfo();
                    this.host = normalizableURL.getHost();
                    this.port = normalizableURL.getPort();
                    this.file = normalizableURL.getFile();
                    int n4 = this.file.lastIndexOf("?");
                    this.path = n4 < 0 ? this.file : this.file.substring(0, n4);
                }
            }
            if (this.protocol == null) {
                throw new MalformedURLException("no protocol: " + string2);
            }
            n2 = string.indexOf(35, n);
            if (n2 >= 0) {
                this.ref = string.substring(n2 + 1, n3);
                n3 = n2;
            }
            this.parse(string, n, n3);
            if (normalizableURL != null) {
                this.normalize();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw malformedURLException;
        }
        catch (Exception exception) {
            throw new MalformedURLException(exception.toString());
        }
    }

    public NormalizableURL(String string, String string2, String string3) {
        this(string, string2, -1, string3);
    }

    public NormalizableURL(String string, String string2, int n, String string3) {
        this.protocol = string;
        this.host = string2;
        this.port = n;
        int n2 = string3.indexOf(35);
        this.file = n2 < 0 ? string3 : string3.substring(0, n2);
        this.ref = n2 < 0 ? null : string3.substring(n2 + 1);
        int n3 = string3.lastIndexOf(63);
        if (n3 >= 0) {
            this.query = string3.substring(n3 + 1);
            this.path = string3.substring(0, n3);
        } else {
            this.path = string3;
        }
        if (string2 != null && string2.length() > 0) {
            this.authority = n == -1 ? string2 : string2 + ":" + n;
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof NormalizableURL)) {
            return false;
        }
        NormalizableURL normalizableURL = (NormalizableURL)object;
        if (!this.sameFile(normalizableURL)) {
            return false;
        }
        return this.compare(this.ref, normalizableURL.getRef());
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFile() {
        if (this.file == null) {
            return "";
        }
        return this.file;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        if (this.path == null) {
            return "";
        }
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public void normalize() throws MalformedURLException {
        int n;
        int n2;
        if (this.path == null) {
            this.file = this.query != null ? "?" + this.query : "";
            return;
        }
        String string = this.path;
        if (string.equals("/.")) {
            this.path = "/";
            this.file = this.query != null ? this.path + "?" + this.query : this.path;
            return;
        }
        if (string.indexOf(92) >= 0) {
            string = string.replace('\\', '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        while ((n2 = string.indexOf("//")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 1);
        }
        while ((n2 = string.indexOf("/./")) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + 2);
        }
        while ((n2 = string.indexOf("/../")) >= 0) {
            if (n2 == 0) {
                throw new MalformedURLException("Invalid relative URL reference");
            }
            n = string.lastIndexOf(47, n2 - 1);
            string = string.substring(0, n) + string.substring(n2 + 3);
        }
        if (string.endsWith("/.")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.endsWith("/..")) {
            n2 = string.length() - 3;
            n = string.lastIndexOf(47, n2 - 1);
            if (n < 0) {
                throw new MalformedURLException("Invalid relative URL reference");
            }
            string = string.substring(0, n + 1);
        }
        this.path = string;
        this.file = this.query != null ? this.path + "?" + this.query : this.path;
    }

    public boolean sameFile(NormalizableURL normalizableURL) {
        if (!this.compare(this.protocol, normalizableURL.getProtocol())) {
            return false;
        }
        if (!this.compare(this.host, normalizableURL.getHost())) {
            return false;
        }
        if (this.port != normalizableURL.getPort()) {
            return false;
        }
        return this.compare(this.file, normalizableURL.getFile());
    }

    public String toExternalForm() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.protocol != null) {
            stringBuffer.append(this.protocol);
            stringBuffer.append(":");
        }
        if (this.authority != null) {
            stringBuffer.append("//");
            stringBuffer.append(this.authority);
        }
        if (this.path != null) {
            stringBuffer.append(this.path);
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        if (this.ref != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.ref);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("URL[");
        stringBuffer.append("authority=");
        stringBuffer.append(this.authority);
        stringBuffer.append(", file=");
        stringBuffer.append(this.file);
        stringBuffer.append(", host=");
        stringBuffer.append(this.host);
        stringBuffer.append(", port=");
        stringBuffer.append(this.port);
        stringBuffer.append(", protocol=");
        stringBuffer.append(this.protocol);
        stringBuffer.append(", query=");
        stringBuffer.append(this.query);
        stringBuffer.append(", ref=");
        stringBuffer.append(this.ref);
        stringBuffer.append(", userInfo=");
        stringBuffer.append(this.userInfo);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private boolean compare(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private void parse(String string, int n, int n2) throws MalformedURLException {
        int n3 = string.lastIndexOf(63, n2 - 1);
        if (n3 >= 0 && n3 < n2) {
            this.query = string.substring(n3 + 1, n2);
            n2 = n3;
        } else {
            this.query = null;
        }
        if (string.indexOf("//", n) == n) {
            int n4 = string.indexOf("/", n + 2);
            if (n4 >= 0 && n4 < n2) {
                this.authority = string.substring(n + 2, n4);
                n = n4;
            } else {
                this.authority = string.substring(n + 2, n2);
                n = n2;
            }
            if (this.authority.length() > 0) {
                int n5;
                int n6 = this.authority.indexOf(64);
                if (n6 >= 0) {
                    this.userInfo = this.authority.substring(0, n6);
                }
                int n7 = this.authority.indexOf(91, n6 + 1);
                int n8 = n6 + 1;
                if (n7 >= 0) {
                    n8 = n7;
                    if ((n7 = this.authority.indexOf(93, n7)) < 0) {
                        throw new MalformedURLException("Closing ']' not found in IPV6 address: " + this.authority);
                    }
                    n6 = n7 - 1;
                }
                if ((n5 = this.authority.indexOf(58, n6 + 1)) >= 0) {
                    try {
                        this.port = Integer.parseInt(this.authority.substring(n5 + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new MalformedURLException(numberFormatException.toString());
                    }
                    this.host = this.authority.substring(n8, n5);
                } else {
                    this.host = this.authority.substring(n8);
                    this.port = -1;
                }
            }
        }
        if (string.indexOf("/", n) == n) {
            this.path = string.substring(n, n2);
            this.file = this.query != null ? this.path + "?" + this.query : this.path;
            return;
        }
        if (this.path == null) {
            this.file = this.query != null ? "?" + this.query : null;
            return;
        }
        if (!this.path.startsWith("/")) {
            throw new MalformedURLException("Base path does not start with '/'");
        }
        if (!this.path.endsWith("/")) {
            this.path = this.path + "/../";
        }
        this.path = this.path + string.substring(n, n2);
        this.file = this.query != null ? this.path + "?" + this.query : this.path;
    }

    public static boolean isSchemeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '+' || c == '-' || c == '.';
    }
}

