/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.download.RemoteFile;
import phex.utils.URLCodecUtils;

public class URLUtil {
    public static String buildBitziLookupURL(URN uRN) {
        String string = "http://bitzi.com/lookup/" + uRN.getNamespaceSpecificString() + "?detail&ref=phex";
        return string;
    }

    public static String buildMagnetURL(String string, String string2) {
        String string3 = "magnet:?xt=urn:sha1:" + string + "&dn=" + URLCodecUtils.encodeURL(string2);
        return string3;
    }

    public static String buildMagnetURLWithXS(String string, String string2, DestAddress destAddress) {
        String string3 = "magnet:?xt=urn:sha1:" + string + "&dn=" + URLCodecUtils.encodeURL(string2) + "&xs=" + URLUtil.buildHostURL(destAddress) + "/uri-res/N2R?" + "urn:sha1:" + string;
        return string3;
    }

    public static String buildFileURL(RemoteFile remoteFile) {
        return "http://" + remoteFile.getHostAddress().getFullHostName() + "/get/" + remoteFile.getFileIndex() + "/" + URLCodecUtils.encodeURL(remoteFile.getFilename());
    }

    public static String buildName2ResourceURL(URN uRN) {
        return "/uri-res/N2R?" + uRN.getAsString();
    }

    public static String buildName2ResThexURL(URN uRN, String string) {
        return "/uri-res/N2X?" + uRN.getAsString() + ";" + string;
    }

    public static String buildFullName2ResourceURL(DestAddress destAddress, URN uRN) {
        return URLUtil.buildHostURL(destAddress) + "/uri-res/N2R?" + uRN.getAsString();
    }

    public static String buildHostURL(DestAddress destAddress) {
        return "http://" + destAddress.getFullHostName();
    }

    public static String getFileNameFromUri(URI uRI) throws URIException {
        String string = uRI.getPath();
        if (string == null) {
            return uRI.getHost();
        }
        int n = string.lastIndexOf("/");
        int n2 = string.length();
        return n >= 0 ? string.substring(n + 1, n2) : string;
    }

    public static String getPathQueryFromUri(URI uRI) throws URIException {
        String string = uRI.getPath();
        String string2 = uRI.getQuery();
        uRI.getCurrentHierPath();
        if (string2 != null && string2.length() > 0) {
            return string + "?" + string2;
        }
        if (string == null) {
            return "/";
        }
        return string;
    }

    public static URN getQueryURN(URI uRI) throws URIException {
        String string = uRI.getQuery();
        if (string != null && string.length() > 0 && URN.isValidURN(string)) {
            return new URN(string);
        }
        return null;
    }
}

