/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import phex.utils.WordTable;

public class WordTableByTree
extends WordTable {
    private Node root = new Node();
    private List gopher = new ArrayList();

    public void store(String string, Object object) {
        this.fillList(this.gopher, string);
        if (this.gopher.isEmpty()) {
            throw new IllegalArgumentException("Key string contains no usefull sub strings");
        }
        Node node = this.root;
        Iterator iterator = this.gopher.iterator();
        while (iterator.hasNext()) {
            node = node.getChild(iterator.next(), true);
        }
        node.addItem(object);
    }

    public void fetch(String string, WordTable.HitListener hitListener) {
        this.fillList(this.gopher, string);
        for (int i = 0; i < this.gopher.size(); ++i) {
            Node node = this.root;
            for (int j = i; j < this.gopher.size() && (node = node.getChild(this.gopher.get(j), false)) != null; ++j) {
                Set set = node.getItems();
                if (set == null) continue;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    hitListener.processHit(iterator.next());
                }
            }
        }
    }

    private void dumpTree(String string, Node node) {
        if (node.children == null) {
            System.out.println(string + node);
        }
        if (node.items != null) {
            System.out.println(string + node.items);
        }
        if (node.children != null) {
            Iterator iterator = node.children.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                System.out.println(string + "-> " + k);
                this.dumpTree(string + "  ", (Node)node.children.get(k));
            }
        }
    }

    private static class Node {
        private Map children;
        private Set items;

        private Node() {
        }

        public Node getChild(Object object, boolean bl) {
            Node node = null;
            if (this.children == null) {
                if (bl) {
                    this.children = new HashMap();
                    node = new Node();
                    this.children.put(object, node);
                }
            } else {
                node = (Node)this.children.get(object);
                if (node == null) {
                    node = new Node();
                    this.children.put(object, node);
                }
            }
            return node;
        }

        public Set getItems() {
            return this.items;
        }

        public void addItem(Object object) {
            if (this.items == null) {
                this.items = new WordTable.DiffSet();
            }
            this.items.add(object);
        }
    }
}

