/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.impl.runtime;

import com.sun.xml.bind.DatatypeConverterImpl;
import com.sun.xml.bind.unmarshaller.DOMScanner;
import com.sun.xml.bind.unmarshaller.InterningXMLReader;
import com.sun.xml.bind.validator.DOMLocator;
import com.sun.xml.bind.validator.Locator;
import com.sun.xml.bind.validator.SAXLocator;
import java.io.IOException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.bind.helpers.AbstractUnmarshallerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import phex.xml.impl.runtime.DefaultJAXBContextImpl;
import phex.xml.impl.runtime.ErrorHandlerAdaptor;
import phex.xml.impl.runtime.GrammarInfo;
import phex.xml.impl.runtime.InterningUnmarshallerHandler;
import phex.xml.impl.runtime.SAXUnmarshallerHandler;
import phex.xml.impl.runtime.SAXUnmarshallerHandlerImpl;

public class UnmarshallerImpl
extends AbstractUnmarshallerImpl {
    private DefaultJAXBContextImpl context = null;
    private final GrammarInfo grammarInfo;
    private static final DefaultHandler dummyHandler = new DefaultHandler();

    public UnmarshallerImpl(DefaultJAXBContextImpl defaultJAXBContextImpl, GrammarInfo grammarInfo) {
        this.context = defaultJAXBContextImpl;
        this.grammarInfo = grammarInfo;
        DatatypeConverter.setDatatypeConverter(DatatypeConverterImpl.theInstance);
    }

    public void setValidating(boolean bl) throws JAXBException {
        throw new UnsupportedOperationException("When generating this code, the compiler option was specified not to generate code for the unmarshal-time validation");
    }

    public UnmarshallerHandler getUnmarshallerHandler() {
        return new InterningUnmarshallerHandler(this.createUnmarshallerHandler(new SAXLocator()));
    }

    private SAXUnmarshallerHandler createUnmarshallerHandler(Locator locator) {
        SAXUnmarshallerHandlerImpl sAXUnmarshallerHandlerImpl = new SAXUnmarshallerHandlerImpl(this, this.grammarInfo);
        return sAXUnmarshallerHandlerImpl;
    }

    protected Object unmarshal(XMLReader xMLReader, InputSource inputSource) throws JAXBException {
        SAXLocator sAXLocator = new SAXLocator();
        SAXUnmarshallerHandler sAXUnmarshallerHandler = this.createUnmarshallerHandler(sAXLocator);
        xMLReader = InterningXMLReader.adapt(xMLReader);
        xMLReader.setContentHandler(sAXUnmarshallerHandler);
        xMLReader.setErrorHandler(new ErrorHandlerAdaptor(sAXUnmarshallerHandler, sAXLocator));
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new JAXBException(iOException);
        }
        catch (SAXException sAXException) {
            throw this.createUnmarshalException(sAXException);
        }
        Object object = sAXUnmarshallerHandler.getResult();
        xMLReader.setContentHandler(dummyHandler);
        xMLReader.setErrorHandler(dummyHandler);
        return object;
    }

    public final Object unmarshal(Node node) throws JAXBException {
        try {
            DOMScanner dOMScanner = new DOMScanner();
            InterningUnmarshallerHandler interningUnmarshallerHandler = new InterningUnmarshallerHandler(this.createUnmarshallerHandler(new DOMLocator(dOMScanner)));
            if (node instanceof Element) {
                dOMScanner.parse((Element)node, interningUnmarshallerHandler);
            } else if (node instanceof Document) {
                dOMScanner.parse(((Document)node).getDocumentElement(), interningUnmarshallerHandler);
            } else {
                throw new IllegalArgumentException();
            }
            return interningUnmarshallerHandler.getResult();
        }
        catch (SAXException sAXException) {
            throw this.createUnmarshalException(sAXException);
        }
    }
}

