/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.DPhex;
import phex.xml.sax.parser.PhexSAXHandler;

public class PhexXmlSaxParser {
    public static DPhex parsePhexXml(InputStream inputStream) throws IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            DPhex dPhex = new DPhex();
            sAXParser.parse(new InputSource(inputStream), (DefaultHandler)new PhexSAXHandler(dPhex, sAXParser));
            return dPhex;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            NLogger.error("GLOBAL", (Object)parserConfigurationException, (Throwable)parserConfigurationException);
            throw new IOException("Parsing Phex XML failed.");
        }
        catch (SAXException sAXException) {
            NLogger.error("GLOBAL", (Object)sAXException, (Throwable)sAXException);
            throw new IOException("Parsing Phex XML failed.");
        }
    }

    public static void main(String[] stringArray) throws IOException, JAXBException {
        long l = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            FileInputStream fileInputStream = new FileInputStream("C:\\temp\\resp.xml");
            PhexXmlSaxParser.parsePhexXml(fileInputStream);
        }
        long l2 = System.currentTimeMillis();
        System.out.println(l2 - l);
        l = System.currentTimeMillis();
        JAXBContext jAXBContext = JAXBContext.newInstance("phex.xml");
        for (int i = 0; i < 1000; ++i) {
            FileInputStream fileInputStream = new FileInputStream("C:\\temp\\resp.xml");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            unmarshaller.unmarshal(fileInputStream);
        }
        l2 = System.currentTimeMillis();
        System.out.println(l2 - l);
    }
}

