/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import phex.utils.NLogger;
import phex.xml.sax.DPhex;

public class PhexXmlSaxWriter {
    private AttributesImpl attributes = new AttributesImpl();
    private TransformerHandler transHandler;

    public static void serializePhexXml(OutputStream outputStream, DPhex dPhex) throws IOException {
        PhexXmlSaxWriter phexXmlSaxWriter = new PhexXmlSaxWriter();
        try {
            phexXmlSaxWriter.writePhexXml(outputStream, dPhex);
        }
        catch (SAXException sAXException) {
            NLogger.error("GLOBAL", (Object)sAXException, (Throwable)sAXException);
            throw new IOException("Serializing Phex XML.");
        }
    }

    public void writePhexXml(OutputStream outputStream, DPhex dPhex) throws SAXException {
        StreamResult streamResult = new StreamResult(outputStream);
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            this.transHandler = sAXTransformerFactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException.getMessage(), transformerConfigurationException);
        }
        Transformer transformer = this.transHandler.getTransformer();
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("indent", "yes");
        this.transHandler.setResult(streamResult);
        this.transHandler.startDocument();
        dPhex.serialize(this);
        this.transHandler.endDocument();
    }

    public void startElm(String string, AttributesImpl attributesImpl) throws SAXException {
        if (attributesImpl == null) {
            this.attributes.clear();
            attributesImpl = this.attributes;
        }
        this.transHandler.startElement("", "", string, attributesImpl);
    }

    public void elmText(String string) throws SAXException {
        this.transHandler.characters(string.toCharArray(), 0, string.length());
    }

    public void elmInt(int n) throws SAXException {
        this.elmText(String.valueOf(n));
    }

    public void elmLong(long l) throws SAXException {
        this.elmText(String.valueOf(l));
    }

    public void elmBol(boolean bl) throws SAXException {
        this.elmText(String.valueOf(bl));
    }

    public void elmHexBinary(byte[] byArray) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(this.hexBinaryEncode(byArray[i] >> 4));
            stringBuffer.append(this.hexBinaryEncode(byArray[i] & 0xF));
        }
        this.elmText(stringBuffer.toString());
    }

    private char hexBinaryEncode(int n) {
        if ((n &= 0xF) < 10) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public void endElm(String string) throws SAXException {
        this.transHandler.endElement("", "", string);
    }
}

