/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.common.file.ManagedFileInputStream;
import phex.common.file.ManagedFileOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.xml.sax.DPhex;
import phex.xml.sax.PhexXmlSaxParser;
import phex.xml.sax.PhexXmlSaxWriter;
import phex.xml.sax.parser.UnicodeInputStream;

public class XMLBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DPhex loadDPhexFromFile(ManagedFile managedFile) throws IOException, ManagedFileException {
        DPhex dPhex;
        if (!managedFile.getFile().exists()) {
            return null;
        }
        NLogger.debug(XMLBuilder.class, (Object)("Loading DPhex from: " + managedFile));
        ManagedFileInputStream managedFileInputStream = null;
        try {
            managedFile.acquireFileLock();
            managedFileInputStream = new ManagedFileInputStream(managedFile, 0L);
            dPhex = XMLBuilder.readDPhexFromStream(managedFileInputStream);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(managedFileInputStream);
            IOUtil.closeQuietly(managedFile);
            managedFile.releaseFileLock();
            throw throwable;
        }
        IOUtil.closeQuietly(managedFileInputStream);
        IOUtil.closeQuietly(managedFile);
        managedFile.releaseFileLock();
        return dPhex;
    }

    public static DPhex readDPhexFromStream(InputStream inputStream) throws IOException {
        UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, "UTF-8");
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedIOException("Thread interrupted.");
        }
        try {
            unicodeInputStream.getEncoding();
        }
        catch (IllegalStateException illegalStateException) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException("Thread interrupted.");
            }
            NLogger.error(XMLBuilder.class, (Object)illegalStateException, (Throwable)illegalStateException);
        }
        DPhex dPhex = PhexXmlSaxParser.parsePhexXml(unicodeInputStream);
        return dPhex;
    }

    public static byte[] serializeToBytes(DPhex dPhex) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PhexXmlSaxWriter.serializePhexXml(byteArrayOutputStream, dPhex);
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToFile(ManagedFile managedFile, DPhex dPhex) throws IOException, ManagedFileException {
        ManagedFileOutputStream managedFileOutputStream = null;
        try {
            managedFile.acquireFileLock();
            managedFile.setLength(0L);
            managedFileOutputStream = new ManagedFileOutputStream(managedFile, 0L);
            PhexXmlSaxWriter.serializePhexXml(managedFileOutputStream, dPhex);
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(managedFileOutputStream);
            IOUtil.closeQuietly(managedFile);
            managedFile.releaseFileLock();
            throw throwable;
        }
        IOUtil.closeQuietly(managedFileOutputStream);
        IOUtil.closeQuietly(managedFile);
        managedFile.releaseFileLock();
    }
}

