/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.favorites;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.favorites.DFavoriteHost;
import phex.xml.sax.parser.ParserUtils;

public class FavoriteHostHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "favorite-host";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DFavoriteHost dHost;
    private DefaultHandler parent;

    public FavoriteHostHandler(DFavoriteHost dFavoriteHost, Attributes attributes, DefaultHandler defaultHandler, SAXParser sAXParser) {
        this.dHost = dFavoriteHost;
        this.parser = sAXParser;
        this.parent = defaultHandler;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.text.reset();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("host-name")) {
            this.dHost.setHostName(this.text.toString());
        } else if (string3.equals("ip")) {
            this.dHost.setIp(ParserUtils.fromHexBinary(this.text.toString()));
        } else if (string3.equals("port")) {
            try {
                this.dHost.setPort(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(FavoriteHostHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return null;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.text.write(cArray, n, n2);
    }
}

