/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.gui;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.gui.DGuiSettings;
import phex.xml.sax.gui.DTab;
import phex.xml.sax.gui.DTableList;
import phex.xml.sax.parser.gui.GuiTabHandler;
import phex.xml.sax.parser.gui.GuiTableListHandler;
import phex.xml.sax.parser.share.SharedFileHandler;

public class GuiSettingsHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "gui-settings";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DGuiSettings dGui;
    private DefaultHandler parent;

    public GuiSettingsHandler(DGuiSettings dGuiSettings, DefaultHandler defaultHandler, SAXParser sAXParser) {
        this.dGui = dGuiSettings;
        this.parser = sAXParser;
        this.parent = defaultHandler;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.text.reset();
        if (string3.equals("tab")) {
            DTab dTab = new DTab();
            this.dGui.getTabList().add(dTab);
            GuiTabHandler guiTabHandler = new GuiTabHandler(dTab, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(guiTabHandler);
        } else if (string3.equals("table-list")) {
            DTableList dTableList = new DTableList();
            this.dGui.setTableList(dTableList);
            GuiTableListHandler guiTableListHandler = new GuiTableListHandler(dTableList, attributes, this, this.parser);
            this.parser.getXMLReader().setContentHandler(guiTableListHandler);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("look-and-feel-class")) {
            this.dGui.setLookAndFeelClass(this.text.toString());
        } else if (string3.equals("is-toolbar-visible")) {
            this.dGui.setToolbarVisible(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("is-statusbar-visible")) {
            this.dGui.setStatusbarVisible(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("is-searchbar-visible")) {
            this.dGui.setSearchBarVisible(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("is-searchlist-visible")) {
            this.dGui.setSearchListVisible(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("is-searchfilterpanel-visible")) {
            this.dGui.setSearchFilterPanelVisible(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("is-log-bandwidth-slider-used")) {
            this.dGui.setLogBandwidthSliderUsed(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("show-respect-copyright-notice")) {
            this.dGui.setShowRespectCopyrightNotice(Boolean.valueOf(this.text.toString()));
        } else if (string3.equals("window-posX")) {
            try {
                this.dGui.setWindowPosX(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("window-posY")) {
            try {
                this.dGui.setWindowPosY(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("window-width")) {
            try {
                this.dGui.setWindowWidth(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("window-height")) {
            try {
                this.dGui.setWindowHeight(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return null;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.text.write(cArray, n, n2);
    }
}

