/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;

public class DimeGenerator {
    private long autoChunkSize;
    private OutputStream out;
    private boolean first;
    private boolean last;
    private HashSet ids;

    public DimeGenerator(OutputStream os) {
        this(os, Integer.MAX_VALUE);
    }

    public DimeGenerator(OutputStream os, long acs) {
        if (acs > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("auto chunk size cannot be bigger than 4294967295");
        }
        this.autoChunkSize = acs;
        this.out = os;
        this.ids = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(DimeRecord dr, boolean l) throws IOException {
        if (this.last) {
            throw new IllegalStateException("DIME message closed");
        }
        if (l) {
            this.last = true;
        }
        if (dr.getId() != null) {
            HashSet hashSet = this.ids;
            synchronized (hashSet) {
                if (this.ids.contains(dr.getId())) {
                    throw new IllegalStateException("Two records can't have the same id");
                }
                this.ids.add(dr.getId());
            }
        }
        dr.produce(this.out, this.autoChunkSize, this.first ? false : (this.first = true), l);
    }

    public static void main(String[] args) throws IOException {
        FileOutputStream out = new FileOutputStream(new File("output.dime"));
        DimeGenerator dg = new DimeGenerator(out);
        String type = "Ry4an type";
        for (int i = 0; i < args.length; ++i) {
            File f = new File(args[i]);
            DimeRecord dr = new DimeRecord(new FileInputStream(f), f.length(), DimeRecord.TypeNameFormat.UNKNOWN, type, null);
            dg.addRecord(dr, i == args.length - 1);
            System.out.println("Added: " + dr);
        }
        out.flush();
        out.close();
    }
}

