/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.ComponentAdapter;

public class JXTree
extends JTree {
    private static final Logger LOG = Logger.getLogger(JXTree.class.getName());
    private Method conversionMethod = null;
    private static final Class[] methodSignature = new Class[]{Object.class};
    private static final Object[] methodArgs = new Object[]{null};
    private ChangeListener highlighterChangeListener;
    private DelegatingRenderer delegatingRenderer;
    private boolean overwriteIcons;
    private final ComponentAdapter dataAdapter = new TreeAdapter(this);

    public JXTree() {
    }

    public JXTree(Object[] value) {
        super(value);
    }

    public JXTree(Vector value) {
        super(value);
    }

    public JXTree(Hashtable value) {
        super(value);
    }

    public JXTree(TreeNode root) {
        super(root, false);
    }

    public JXTree(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public JXTree(TreeModel newModel) {
        super(newModel);
        this.conversionMethod = this.getValueConversionMethod(newModel);
    }

    public void setModel(TreeModel newModel) {
        this.conversionMethod = this.getValueConversionMethod(newModel);
        super.setModel(newModel);
    }

    private Method getValueConversionMethod(TreeModel model) {
        try {
            return model == null ? null : model.getClass().getMethod("convertValueToText", methodSignature);
        }
        catch (NoSuchMethodException ex) {
            LOG.finer("ex " + ex);
            LOG.finer("no conversionMethod in " + model.getClass());
            return null;
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value != null) {
            if (this.conversionMethod == null) {
                return value.toString();
            }
            try {
                JXTree.methodArgs[0] = value;
                return (String)this.conversionMethod.invoke((Object)this.getModel(), methodArgs);
            }
            catch (Exception ex) {
                LOG.finer("ex " + ex);
                LOG.finer("can't invoke " + this.conversionMethod);
            }
        }
        return "";
    }

    public void collapseAll() {
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            this.collapseRow(i);
        }
    }

    public void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    private ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    JXTree.this.repaint();
                }
            };
        }
        return this.highlighterChangeListener;
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
            this.delegatingRenderer.setDelegateRenderer(super.getCellRenderer());
        }
        return this.delegatingRenderer;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    public void setExpandedIcon(Icon expanded) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setExpandedIcon(expanded);
        }
    }

    public void setCollapsedIcon(Icon collapsed) {
        if (this.getUI() instanceof BasicTreeUI) {
            ((BasicTreeUI)this.getUI()).setCollapsedIcon(collapsed);
        }
    }

    public void setLeafIcon(Icon leafIcon) {
        this.getDelegatingRenderer().setLeafIcon(leafIcon);
    }

    public void setOpenIcon(Icon openIcon) {
        this.getDelegatingRenderer().setOpenIcon(openIcon);
    }

    public void setClosedIcon(Icon closedIcon) {
        this.getDelegatingRenderer().setClosedIcon(closedIcon);
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        if (this.overwriteIcons == overwrite) {
            return;
        }
        boolean old = this.overwriteIcons;
        this.overwriteIcons = overwrite;
        this.firePropertyChange("overwriteRendererIcons", old, overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.overwriteIcons;
    }

    protected ComponentAdapter getComponentAdapter() {
        return this.dataAdapter;
    }

    protected static class TreeAdapter
    extends ComponentAdapter {
        private final JXTree tree;

        public TreeAdapter(JXTree component) {
            super(component);
            this.tree = component;
        }

        public JXTree getTree() {
            return this.tree;
        }

        public boolean hasFocus() {
            return this.tree.isFocusOwner() && this.tree.getLeadSelectionRow() == this.row;
        }

        public Object getValueAt(int row, int column) {
            TreePath path = this.tree.getPathForRow(row);
            return path.getLastPathComponent();
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.getValueAt(row, column);
        }

        public boolean isSelected() {
            return this.tree.isRowSelected(this.row);
        }

        public boolean isExpanded() {
            return this.tree.isExpanded(this.row);
        }

        public boolean isLeaf() {
            return this.tree.getModel().isLeaf(this.getValue());
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public void setValueAt(Object aValue, int row, int column) {
        }

        public String getColumnName(int columnIndex) {
            return "Column_" + columnIndex;
        }

        public String getColumnIdentifier(int columnIndex) {
            return null;
        }
    }

    public class DelegatingRenderer
    implements TreeCellRenderer {
        private Icon closedIcon = null;
        private Icon openIcon = null;
        private Icon leafIcon = null;
        private TreeCellRenderer delegate;

        public DelegatingRenderer() {
            this.initIcons(new DefaultTreeCellRenderer());
        }

        private void initIcons(DefaultTreeCellRenderer renderer) {
            this.closedIcon = renderer.getDefaultClosedIcon();
            this.openIcon = renderer.getDefaultOpenIcon();
            this.leafIcon = renderer.getDefaultLeafIcon();
        }

        public void setDelegateRenderer(TreeCellRenderer delegate) {
            if (delegate == null) {
                delegate = new DefaultTreeCellRenderer();
            }
            this.delegate = delegate;
            this.updateIcons();
        }

        private void updateIcons() {
            if (!JXTree.this.isOverwriteRendererIcons()) {
                return;
            }
            this.setClosedIcon(this.closedIcon);
            this.setOpenIcon(this.openIcon);
            this.setLeafIcon(this.leafIcon);
        }

        public void setClosedIcon(Icon closedIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setClosedIcon(closedIcon);
            }
            this.closedIcon = closedIcon;
        }

        public void setOpenIcon(Icon openIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setOpenIcon(openIcon);
            }
            this.openIcon = openIcon;
        }

        public void setLeafIcon(Icon leafIcon) {
            if (this.delegate instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)this.delegate).setLeafIcon(leafIcon);
            }
            this.leafIcon = leafIcon;
        }

        public TreeCellRenderer getDelegateRenderer() {
            return this.delegate;
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component result = this.delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            return result;
        }
    }
}

