/*
 * Decompiled with CFR 0.152.
 */
package phex;

import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang.SystemUtils;
import phex.common.Environment;
import phex.common.ManagerController;
import phex.common.ThreadTracking;
import phex.connection.LoopbackDispatcher;
import phex.connection.NetworkManager;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gui.common.SplashWindow;
import phex.utils.Localizer;
import phex.utils.Logger;
import phex.utils.NLogger;

public class Main {
    public static void main(String[] args) {
        String argument;
        long start = System.currentTimeMillis();
        Main.validateJavaVersion();
        Iterator<String> iterator = Arrays.asList(args).iterator();
        String startupUri = null;
        String loopbackUri = null;
        String magmaFile = null;
        String rssFile = null;
        while ((argument = Main.readArgument(iterator)) != null) {
            if (argument.equalsIgnoreCase("-c")) {
                String path = Main.readArgument(iterator);
                if (path == null) continue;
                File configRoot = new File(path);
                try {
                    Environment.getInstance().setPhexConfigRoot(configRoot);
                }
                catch (IOException exp) {
                    exp.printStackTrace();
                }
                continue;
            }
            if (argument.equalsIgnoreCase("-uri")) {
                loopbackUri = Main.readArgument(iterator);
                continue;
            }
            if (argument.equalsIgnoreCase("-magma")) {
                magmaFile = Main.readArgument(iterator);
                continue;
            }
            if (!argument.equalsIgnoreCase("-rss")) continue;
            rssFile = Main.readArgument(iterator);
        }
        if (loopbackUri != null && LoopbackDispatcher.dispatchUri(loopbackUri)) {
            System.exit(0);
        }
        if (magmaFile != null && LoopbackDispatcher.dispatchMagmaFile(magmaFile)) {
            System.exit(0);
        }
        if (rssFile != null && LoopbackDispatcher.dispatchRSSFile(rssFile)) {
            System.exit(0);
        }
        try {
            SplashWindow splashWindow = null;
            try {
                splashWindow = new SplashWindow();
                splashWindow.showSplash();
            }
            catch (HeadlessException ex) {
                // empty catch block
            }
            Localizer.initialize();
            ThreadTracking.initialize();
            ManagerController.initializeManagers();
            long end = System.currentTimeMillis();
            Logger.logMessage(Logger.FINEST, (short)255, "Pre GUI startup time: " + (end - start));
            try {
                GUIRegistry.getInstance().initialize();
            }
            catch (ExceptionInInitializerError ex) {
                // empty catch block
            }
            if (splashWindow != null) {
                splashWindow.dispose();
            }
            MainFrame mainFrame = null;
            mainFrame = GUIRegistry.getInstance().getMainFrame();
            if (mainFrame != null) {
                mainFrame.setVisible(true);
            }
            end = System.currentTimeMillis();
            Logger.logMessage(Logger.FINEST, (short)255, "Full startup time: " + (end - start));
            ManagerController.startupCompletedNotify();
            if (startupUri != null) {
                NetworkManager.getInstance().fireIncomingUriDownload(startupUri);
            }
            if (loopbackUri != null) {
                NetworkManager.getInstance().fireIncomingUriDownload(loopbackUri);
            }
            if (magmaFile != null) {
                NetworkManager.getInstance().fireIncomingMagmaDownload(magmaFile);
            }
            if (rssFile != null) {
                NetworkManager.getInstance().fireIncomingRSSDownload(magmaFile);
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
            NLogger.error("GLOBAL", (Object)th, th);
            System.exit(1);
        }
    }

    private static String readArgument(Iterator iterator) {
        if (!iterator.hasNext()) {
            return null;
        }
        String value = (String)iterator.next();
        return value;
    }

    private static void validateJavaVersion() {
        if (SystemUtils.isJavaVersionAtLeast(1.4f)) {
            return;
        }
        JFrame frame = new JFrame("Wrong Java Version");
        frame.setSize(new Dimension(0, 0));
        frame.setVisible(true);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension winSize = frame.getSize();
        Rectangle rect = new Rectangle((screenSize.width - winSize.width) / 2, (screenSize.height - winSize.height) / 2, winSize.width, winSize.height);
        frame.setBounds(rect);
        JOptionPane.showMessageDialog(frame, "Please use a newer Java VM.\nPhex requires at least Java 1.4.0. You are using Java " + SystemUtils.JAVA_VERSION + "\n" + "To get the latest Java release go to http://java.com.", "Wrong Java Version", 2);
        System.exit(1);
    }
}

