/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import phex.chat.ChatManager;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.utils.BandwidthInputStream;
import phex.utils.BandwidthOutputStream;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class ChatEngine {
    private boolean isOutgoingConnection;
    private SocketFacade socket;
    private GnutellaInputStream chatReader;
    private BufferedWriter chatWriter;
    private String chatNick;
    private DestAddress hostAddress;

    public ChatEngine(SocketFacade aSocket, GnutellaInputStream gInStream, DestAddress aHostAddress) throws IOException {
        this.socket = aSocket;
        this.hostAddress = aHostAddress;
        this.chatReader = gInStream;
        BandwidthOutputStream bandwidthOutStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutStream));
        this.chatNick = this.hostAddress.getHostName();
        this.finalizeHandshake();
        this.isOutgoingConnection = false;
    }

    public ChatEngine(DestAddress aHostAddress) {
        this.hostAddress = aHostAddress;
        this.isOutgoingConnection = true;
        this.chatNick = this.hostAddress.getHostName();
    }

    public void startChat() {
        ChatReadWorker worker = new ChatReadWorker();
        ThreadPool.getInstance().addJob(worker, "ChatReadWorker-" + Integer.toHexString(worker.hashCode()));
    }

    public void stopChat() {
        if (this.chatReader != null) {
            this.chatReader.close();
            this.chatReader = null;
        }
        IOUtil.closeQuietly(this.chatWriter);
        this.chatWriter = null;
        IOUtil.closeQuietly(this.socket);
        this.socket = null;
        ChatManager.getInstance().chatClosed(this);
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getChatNick() {
        return this.chatNick;
    }

    public void sendChatMessage(String message) {
        if (this.chatWriter == null) {
            ChatManager.getInstance().fireChatConnectionFailed(this);
        }
        try {
            this.chatWriter.write(message + "\n");
            this.chatWriter.flush();
        }
        catch (IOException exp) {
            NLogger.warn(ChatEngine.class, (Object)exp, (Throwable)exp);
            this.stopChat();
        }
    }

    private void finalizeHandshake() throws IOException {
        String line;
        this.socket.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        do {
            line = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (!upLine.startsWith("X-NICKNAME:")) continue;
            this.chatNick = line.substring(11).trim();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Chat Nick: " + this.chatNick));
        } while (line.length() > 0);
        NLogger.debug(ChatEngine.class, (Object)"Sending: CHAT/0.1 200 OK");
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n");
        this.chatWriter.flush();
        do {
            line = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat response: " + line));
            if (line != null) continue;
            throw new IOException("No handshake response from chat partner.");
        } while (line.length() > 0);
        this.socket.setSoTimeout(0);
    }

    private void connectOutgoingChat() throws IOException {
        String line;
        NLogger.debug(ChatEngine.class, (Object)("Connect outgoing to: " + this.hostAddress));
        this.socket = OIOSocketFactory.connect(this.hostAddress, ServiceManager.sCfg.mNetConnectionTimeout);
        BandwidthOutputStream bandwidthOutStream = new BandwidthOutputStream(this.socket.getOutputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatWriter = new BufferedWriter(new OutputStreamWriter(bandwidthOutStream));
        String message = "CHAT CONNECT/0.1\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n" + "\r\n";
        NLogger.debug(ChatEngine.class, (Object)("Sending: " + message));
        this.chatWriter.write(message);
        this.chatWriter.flush();
        BandwidthInputStream bandwidthInputStream = new BandwidthInputStream(this.socket.getInputStream(), BandwidthManager.getInstance().getNetworkBandwidthController());
        this.chatReader = new GnutellaInputStream(bandwidthInputStream);
        do {
            line = this.chatReader.readLine();
            NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Read Chat header: " + line));
            if (line == null) {
                throw new IOException("No handshake response from chat partner.");
            }
            String upLine = line.toUpperCase();
            if (!upLine.startsWith("X-NICKNAME:")) continue;
            this.chatNick = line.substring(11).trim();
        } while (line.length() > 0);
        this.chatWriter.write("CHAT/0.1 200 OK\r\nUser-Agent: " + Environment.getPhexVendor() + "\r\n\r\n");
        this.chatWriter.flush();
        this.socket.setSoTimeout(0);
    }

    private class ChatReadWorker
    implements Runnable {
        private ChatReadWorker() {
        }

        public void run() {
            if (ChatEngine.this.isOutgoingConnection) {
                try {
                    ChatEngine.this.connectOutgoingChat();
                }
                catch (IOException exp) {
                    ChatEngine.this.stopChat();
                    return;
                }
            }
            ChatManager chatManager = ChatManager.getInstance();
            try {
                while (true) {
                    String str;
                    if ((str = ChatEngine.this.chatReader.readLine()) == null) {
                        throw new IOException("Remote host diconnected chat.");
                    }
                    if (str.length() == 0) continue;
                    NLogger.debug(class$phex$chat$ChatEngine == null ? ChatEngine.class$("phex.chat.ChatEngine") : class$phex$chat$ChatEngine, (Object)("Reading chat message: " + str));
                    chatManager.fireChatMessageReceived(ChatEngine.this, str);
                }
            }
            catch (IOException exp) {
                NLogger.debug(class$phex$chat$ChatEngine == null ? (class$phex$chat$ChatEngine = ChatEngine.class$("phex.chat.ChatEngine")) : class$phex$chat$ChatEngine, (Object)exp, (Throwable)exp);
                ChatEngine.this.stopChat();
                return;
            }
        }
    }
}

