/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;
import phex.common.AlternateLocation;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.http.HTTPHeader;
import phex.utils.NLogger;
import phex.xml.sax.share.DAlternateLocation;

public class AltLocContainer {
    public static final int MAX_ALT_LOC_COUNT = 100;
    private static final Object PRESENT;
    private URN urn;
    private SequencedHashMap altLocationMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AltLocContainer(URN urn) {
        if (urn == null) {
            throw new NullPointerException("URN must be provided");
        }
        this.urn = urn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainer(AltLocContainer cont) {
        if (cont.urn == null || !cont.urn.equals(this.urn)) {
            throw new IllegalArgumentException("Trying to add container with not matching urns");
        }
        if (cont.altLocationMap == null) {
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = cont.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = cont.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation tempAltLoc = (AlternateLocation)iterator.next();
                this.addAlternateLocation(tempAltLoc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlternateLocation(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (altLocURN == null || !altLocURN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant add alt-location with not matching URN to container.");
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Cant add alt-location with not matching URN to container.");
            }
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.put(altLoc, PRESENT);
            if (this.altLocationMap.size() > 100) {
                Object firstKey = this.altLocationMap.getFirstKey();
                this.altLocationMap.remove(firstKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlternateLocation(AlternateLocation altLoc) {
        URN altLocURN = altLoc.getURN();
        if (altLocURN == null || !altLocURN.equals(this.urn)) {
            NLogger.warn(AltLocContainer.class, (Object)"Cant remove alt-location with not matching URN from container.");
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Cant remove alt-location with not matching URN from container.");
            }
            return;
        }
        this.initMap();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            this.altLocationMap.remove(altLoc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAltLocForQueryResponseRecord() {
        if (this.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            HashSet<DestAddress> result = new HashSet<DestAddress>();
            while (iterator.hasNext() && result.size() < 10) {
                AlternateLocation altLoc = (AlternateLocation)iterator.next();
                DestAddress destAddress = altLoc.getHostAddress();
                if (!destAddress.isIpHostName() || !destAddress.isLocalHost()) continue;
                result.add(destAddress);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPHeader getAltLocHTTPHeaderForAddress(String headerName, DestAddress hostAddress, Set sendAltLocSet) {
        if (this.isEmpty()) {
            return null;
        }
        int count = 0;
        StringBuffer headerValue = new StringBuffer();
        SequencedHashMap sequencedHashMap = this.altLocationMap;
        synchronized (sequencedHashMap) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation altLoc = (AlternateLocation)iterator.next();
                if (hostAddress.getHostName().equals(altLoc.getHostAddress().getHostName()) || sendAltLocSet.contains(altLoc)) continue;
                if (count > 0) {
                    headerValue.append(",");
                }
                headerValue.append(altLoc.getHTTPString());
                sendAltLocSet.add(altLoc);
                if (++count != 10) continue;
                break;
            }
        }
        if (headerValue.length() > 0) {
            HTTPHeader altLocHeader = new HTTPHeader(headerName, headerValue.toString());
            return altLocHeader;
        }
        return null;
    }

    public synchronized int getSize() {
        if (this.altLocationMap == null) {
            return 0;
        }
        return this.altLocationMap.size();
    }

    public synchronized boolean isEmpty() {
        if (this.altLocationMap == null) {
            return true;
        }
        return this.altLocationMap.isEmpty();
    }

    public synchronized void createDAlternateLocationList(List list) {
        if (this.altLocationMap == null) {
            return;
        }
        Iterator iterator = this.altLocationMap.keySet().iterator();
        while (iterator.hasNext()) {
            AlternateLocation altLoc = (AlternateLocation)iterator.next();
            DAlternateLocation dAltLoc = new DAlternateLocation();
            dAltLoc.setHostAddress(altLoc.getHostAddress().getFullHostName());
            dAltLoc.setUrn(altLoc.getURN().getAsString());
            list.add(dAltLoc);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alt-Locations(SHA1: ");
        stringBuffer.append(this.urn.getAsString());
        stringBuffer.append(")=[ ");
        if (this.altLocationMap != null) {
            Iterator iterator = this.altLocationMap.keySet().iterator();
            while (iterator.hasNext()) {
                AlternateLocation altLoc = (AlternateLocation)iterator.next();
                stringBuffer.append(altLoc.toString());
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private void initMap() {
        if (this.altLocationMap == null) {
            this.altLocationMap = new SequencedHashMap();
        }
    }

    public static List parseUriResAltLocFromHeaders(HTTPHeader[] headers) {
        if (headers.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> altLocList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String altLocationStr = tokenizer.nextToken().trim();
                    AlternateLocation altLocation = AlternateLocation.parseUriResAltLoc(altLocationStr);
                    if (altLocation == null) continue;
                    altLocList.add(altLocation);
                }
                catch (Exception exp) {
                    NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
                }
            }
        }
        return altLocList;
    }

    public static List parseCompactIpAltLocFromHeaders(HTTPHeader[] headers, URN urn) {
        if (headers.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AlternateLocation> altLocList = new ArrayList<AlternateLocation>();
        for (int i = 0; i < headers.length; ++i) {
            HTTPHeader header = headers[i];
            StringTokenizer tokenizer = new StringTokenizer(header.getValue(), ",");
            while (tokenizer.hasMoreTokens()) {
                try {
                    String altLocationStr = tokenizer.nextToken().trim();
                    AlternateLocation altLocation = AlternateLocation.parseCompactIpAltLoc(altLocationStr, urn);
                    if (altLocation == null) continue;
                    altLocList.add(altLocation);
                }
                catch (Exception exp) {
                    NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
                }
            }
        }
        return altLocList;
    }

    static {
        $assertionsDisabled = !AltLocContainer.class.desiredAssertionStatus();
        PRESENT = new Object();
    }
}

