/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import phex.chat.ChatManager;
import phex.common.Ip2CountryManager;
import phex.common.Manager;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.NetworkManager;
import phex.download.swarming.SwarmingManager;
import phex.gwebcache.GWebCacheManager;
import phex.host.HostManager;
import phex.msg.MsgManager;
import phex.query.QueryManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareManager;
import phex.statistic.StatisticsManager;
import phex.udp.UdpConnectionManager;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.upload.UploadManager;
import phex.utils.NLogger;

public class ManagerController {
    private static final List MANAGER_LIST;

    public static void initializeManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Initializing " + manager.getClass().getName()));
            boolean succ = manager.initialize();
            if (!succ) {
                NLogger.error("GLOBAL", "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long end = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Initialization time: " + (end - start) + " - " + manager.getClass().getName()));
        }
        ManagerController.postInitializeManagers();
    }

    private static void postInitializeManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("On post initialization " + manager.getClass().getName()));
            boolean succ = manager.onPostInitialization();
            if (!succ) {
                NLogger.error("GLOBAL", "Failed to initialize " + manager.getClass().getName());
                throw new RuntimeException("Failed to initialize " + manager.getClass().getName());
            }
            long end = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("Post-Initialization time: " + (end - start) + " - " + manager.getClass().getName()));
        }
    }

    public static void startupCompletedNotify() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            Manager manager = (Manager)iterator.next();
            long start = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("StartupCompletedNotify " + manager.getClass().getName()));
            manager.startupCompletedNotify();
            long end = System.currentTimeMillis();
            NLogger.debug("GLOBAL", (Object)("StartupCompletedNotify time: " + (end - start) + " - " + manager.getClass().getName()));
        }
    }

    public static void shutdownManagers() {
        Iterator iterator = MANAGER_LIST.iterator();
        while (iterator.hasNext()) {
            try {
                Manager manager = (Manager)iterator.next();
                long start = System.currentTimeMillis();
                NLogger.debug("GLOBAL", (Object)("Shutdown " + manager.getClass().getName()));
                manager.shutdown();
                long end = System.currentTimeMillis();
                NLogger.debug("GLOBAL", (Object)("Shutdown time: " + (end - start) + " - " + manager.getClass().getName()));
            }
            catch (Exception exp) {
                NLogger.error("GLOBAL", (Object)exp, (Throwable)exp);
            }
        }
    }

    static {
        ArrayList<Manager> tmpList = new ArrayList<Manager>();
        tmpList.add(SwarmingManager.getInstance());
        tmpList.add(NetworkManager.getInstance());
        tmpList.add(UdpConnectionManager.getInstance());
        tmpList.add(UploadManager.getInstance());
        tmpList.add(ShareManager.getInstance());
        tmpList.add(QueryManager.getInstance());
        tmpList.add(ChatManager.getInstance());
        tmpList.add(HostManager.getInstance());
        tmpList.add(PhexSecurityManager.getInstance());
        tmpList.add(MsgManager.getInstance());
        tmpList.add(StatisticsManager.getInstance());
        tmpList.add(BandwidthManager.getInstance());
        tmpList.add(GWebCacheManager.getInstance());
        tmpList.add(Ip2CountryManager.getInstance());
        tmpList.add(UdpHostCacheManager.getInstance());
        MANAGER_LIST = Collections.unmodifiableList(tmpList);
    }
}

