/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import phex.common.Cfg;
import phex.common.URN;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.InvalidMessageException;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;
import phex.msg.QueryMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;

public class QueryRoutingTable {
    public static final byte DEFAULT_INFINITY_TTL = 7;
    public static final int DEFAULT_TABLE_SIZE = 65536;
    private BitSet qrTable;
    private BitSet resizedQRTable;
    private int tableSize;
    private byte tableBits;
    private byte infinity;
    private int entryCount;
    private byte sequenceSize;
    private byte sequenceNumber;
    private int patchPosition;
    private Inflater inflater;
    private static final int A_INT = 1327217884;

    public QueryRoutingTable() {
        this.init(65536, (byte)7);
    }

    private void init(int tableSize, byte infinity) {
        this.tableSize = tableSize;
        this.infinity = infinity;
        this.tableBits = IOUtil.calculateLog2(tableSize);
        this.qrTable = new BitSet(tableSize);
        this.resizedQRTable = null;
        this.entryCount = 0;
        this.sequenceSize = 0;
        this.sequenceNumber = 0;
        this.patchPosition = 0;
        this.inflater = null;
    }

    public void aggregateToRouteTable(QueryRoutingTable queryRoutingTable) {
        BitSet bitSetToAggregate = this.tableSize != queryRoutingTable.tableSize ? queryRoutingTable.resizeRouteTable(this.tableSize) : queryRoutingTable.qrTable;
        this.qrTable.or(bitSetToAggregate);
    }

    private void add(String absoluteFilePath) {
        String[] words = QueryRoutingTable.splitFilePath(absoluteFilePath);
        for (int i = 0; i < words.length; ++i) {
            int hashVal = QueryRoutingTable.qrpHash(words[i], 0, words[i].length(), this.tableBits);
            if (this.qrTable.get(hashVal)) continue;
            ++this.entryCount;
            this.qrTable.set(hashVal);
            this.resizedQRTable = null;
        }
    }

    private void addWord(String singleWord) {
        int hashVal = QueryRoutingTable.qrpHash(singleWord, 0, singleWord.length(), this.tableBits);
        if (!this.qrTable.get(hashVal)) {
            ++this.entryCount;
            this.qrTable.set(hashVal);
            this.resizedQRTable = null;
        }
    }

    public boolean containsQuery(QueryMsg query) {
        boolean isInvalidSearchString;
        String searchString = query.getSearchString();
        boolean bl = isInvalidSearchString = searchString == null || searchString.length() < Cfg.MIN_SEARCH_TERM_LENGTH;
        if (query.hasQueryURNs() && isInvalidSearchString) {
            URN[] urns = query.getQueryURNs();
            for (int i = 0; i < urns.length; ++i) {
                String urnString = urns[i].getAsString();
                int hashVal = QueryRoutingTable.qrpHash(urnString, 0, urnString.length(), this.tableBits);
                if (!this.qrTable.get(hashVal)) continue;
                return true;
            }
            return false;
        }
        if (isInvalidSearchString) {
            return false;
        }
        String[] words = QueryRoutingTable.splitQueryString(searchString);
        for (int i = 0; i < words.length; ++i) {
            int hashVal = QueryRoutingTable.qrpHash(words[i], 0, words[i].length(), this.tableBits);
            if (this.qrTable.get(hashVal)) continue;
            return false;
        }
        return true;
    }

    public void updateRouteTable(RouteTableUpdateMsg message) throws InvalidMessageException {
        if (message.getVariant() == 0) {
            int tableSize = ((QRResetTableMsg)message).getTableSize();
            Logger.logMessage(Logger.FINER, (short)16, "Reseting QRT from: " + message.getHeader().getFromHost() + " Size: " + tableSize);
            this.init(tableSize, this.infinity);
        } else if (message.getVariant() == 1) {
            byte entryBits;
            QRPatchTableMsg patchMessage = (QRPatchTableMsg)message;
            byte msgSequenceSize = patchMessage.getSequenceSize();
            byte msgSequenceNumber = patchMessage.getSequenceNumber();
            Logger.logMessage(Logger.FINER, (short)16, "Patching QRT from: " + message.getHeader().getFromHost() + " " + msgSequenceNumber + "/" + msgSequenceSize);
            if (this.sequenceSize == 0 && this.sequenceNumber == 0) {
                this.sequenceSize = msgSequenceSize;
                this.sequenceNumber = 1;
            }
            if (this.sequenceSize != msgSequenceSize || msgSequenceNumber != this.sequenceNumber || msgSequenceSize == 0) {
                throw new InvalidMessageException("QRTPatchMsg sequence size or number not valid.\nSize: (" + msgSequenceSize + "/" + this.sequenceSize + ").\n" + "Number: (" + msgSequenceNumber + "/" + this.sequenceNumber + ").");
            }
            this.sequenceNumber = msgSequenceNumber;
            byte[] patchData = patchMessage.getPatchData();
            byte compressor = patchMessage.getCompressor();
            if (compressor == 1) {
                block30: {
                    if (this.sequenceNumber == 1) {
                        this.inflater = new Inflater();
                    }
                    try {
                        patchData = IOUtil.inflate(this.inflater, patchData);
                    }
                    catch (DataFormatException exp) {
                        patchData = null;
                        if (!NLogger.isWarnEnabled(QueryRoutingTable.class)) break block30;
                        NLogger.warn(QueryRoutingTable.class, (Object)"Invalid QRT data format to inflate.", (Throwable)exp);
                    }
                }
                if (patchData == null) {
                    throw new InvalidMessageException("Can't inflate patch data");
                }
            } else if (compressor != 0) {
                throw new InvalidMessageException("QRTPatchMsg Unknown compression: " + compressor);
            }
            if ((entryBits = patchMessage.getEntryBits()) == 4) {
                byte[] buf = new byte[patchData.length * 2];
                for (int i = 0; i < patchData.length; ++i) {
                    buf[i * 2] = (byte)(patchData[i] >> 4);
                    byte tmpVal = (byte)(patchData[i] & 0xF);
                    if ((tmpVal & 8) != 0) {
                        tmpVal = (byte)(0xF0 | tmpVal);
                    }
                    buf[i * 2 + 1] = tmpVal;
                }
                patchData = buf;
            } else if (entryBits != 8) {
                throw new InvalidMessageException("QRTPatchMsg Unknown ENTRY_BITS value: " + entryBits);
            }
            try {
                byte loggedInvalidPatchFieldValue = 0;
                for (int i = 0; i < patchData.length; ++i) {
                    boolean prevBitSet = this.qrTable.get(this.patchPosition);
                    if (patchData[i] < 0) {
                        this.qrTable.set(this.patchPosition);
                        this.resizedQRTable = null;
                    } else if (patchData[i] > 0) {
                        this.qrTable.clear(this.patchPosition);
                        this.resizedQRTable = null;
                    } else if (patchData[i] != 0 && (loggedInvalidPatchFieldValue == 0 || loggedInvalidPatchFieldValue != patchData[i])) {
                        NLogger.warn(class$phex$common$QueryRoutingTable == null ? QueryRoutingTable.class$("phex.common.QueryRoutingTable") : class$phex$common$QueryRoutingTable, (Object)("Received invalid PatchData field value: " + patchData[i] + " - " + message.getHeader().getFromHost()));
                        loggedInvalidPatchFieldValue = patchData[i];
                    }
                    boolean currBitSet = this.qrTable.get(this.patchPosition);
                    if (prevBitSet && !currBitSet) {
                        --this.entryCount;
                    } else if (!prevBitSet && currBitSet) {
                        ++this.entryCount;
                    }
                    ++this.patchPosition;
                }
            }
            catch (IndexOutOfBoundsException exp) {
                throw new InvalidMessageException("QRTPatchMsg Wrong patch message data size.");
            }
            if (this.sequenceNumber == this.sequenceSize) {
                this.sequenceSize = 0;
                this.sequenceNumber = 0;
                this.patchPosition = 0;
                this.inflater = null;
                Logger.logMessage(Logger.FINER, (short)16, "Updated QRT: " + this.entryCount + " / " + this.tableSize);
            } else {
                this.sequenceNumber = (byte)(this.sequenceNumber + 1);
            }
        }
    }

    private BitSet resizeRouteTable(int newSize) {
        if (this.tableSize == newSize) {
            return this.qrTable;
        }
        if (this.resizedQRTable != null && this.resizedQRTable.size() == newSize) {
            return this.resizedQRTable;
        }
        this.resizedQRTable = new BitSet(newSize);
        double factor = (double)newSize / (double)this.tableSize;
        for (int i = 0; i < this.tableSize; ++i) {
            if (!this.qrTable.get(i)) continue;
            int from = (int)Math.floor((double)i * factor);
            int to = (int)Math.ceil((double)(i + 1) * factor);
            for (int j = from; j < to; ++j) {
                this.resizedQRTable.set(j);
            }
        }
        return this.resizedQRTable;
    }

    private static String[] splitQueryString(String queryString) {
        StringTokenizer tokenizer = new StringTokenizer(queryString, " -._+/*()[]\\");
        ArrayList<String> list = new ArrayList<String>(10);
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            list.add(word);
        }
        String[] strArr = new String[list.size()];
        list.toArray(strArr);
        return strArr;
    }

    private static String[] splitFilePath(String filePath) {
        StringTokenizer tokenizer = new StringTokenizer(filePath, " -._+/*()[]\\");
        ArrayList<String> list = new ArrayList<String>(20);
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            list.add(word);
            int length = word.length();
            for (int i = 1; i < 5 && length - i > 5; ++i) {
                list.add(word.substring(0, length - i));
            }
        }
        String[] strArr = new String[list.size()];
        list.toArray(strArr);
        return strArr;
    }

    public static QueryRoutingTable createLocalQueryRoutingTable() {
        long start = System.currentTimeMillis();
        QueryRoutingTable qrTable = new QueryRoutingTable();
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        ShareFile[] sharedFiles = sharedFilesService.getSharedFiles();
        HashSet<String> wordSet = new HashSet<String>();
        for (int i = 0; i < sharedFiles.length; ++i) {
            String[] words = QueryRoutingTable.splitFilePath(sharedFiles[i].getSystemFile().getAbsolutePath());
            for (int j = 0; j < words.length; ++j) {
                wordSet.add(words[j]);
            }
        }
        Iterator iterator = wordSet.iterator();
        while (iterator.hasNext()) {
            qrTable.addWord((String)iterator.next());
        }
        HostManager hostMgr = HostManager.getInstance();
        if (hostMgr.isUltrapeer()) {
            Host[] leaves = hostMgr.getNetworkHostsContainer().getLeafConnections();
            for (int i = 0; i < leaves.length; ++i) {
                QueryRoutingTable hostQRT = leaves[i].getLastReceivedRoutingTable();
                if (hostQRT == null) continue;
                qrTable.aggregateToRouteTable(hostQRT);
            }
        }
        long end = System.currentTimeMillis();
        Logger.logMessage(Logger.FINER, (short)16, "Created QRT: " + qrTable.entryCount + " / " + qrTable.tableSize + " time: " + (end - start));
        return qrTable;
    }

    public static Iterator buildRouteTableUpdateMsgIterator(QueryRoutingTable currentTable, QueryRoutingTable oldTable) {
        int length;
        ArrayList<RouteTableUpdateMsg> msgList = new ArrayList<RouteTableUpdateMsg>();
        if (oldTable == null) {
            msgList.add(new QRResetTableMsg(currentTable.tableSize, currentTable.infinity));
        }
        boolean isPatchNeeded = false;
        byte[] patchData = new byte[currentTable.tableSize / 2];
        for (int i = 0; i < patchData.length; ++i) {
            byte b2;
            byte b1;
            if (oldTable == null) {
                b1 = currentTable.qrTable.get(i * 2) ? (byte)(1 - currentTable.infinity) : (byte)0;
                b2 = currentTable.qrTable.get(i * 2 + 1) ? (byte)(1 - currentTable.infinity) : (byte)0;
            } else {
                boolean currentVal = currentTable.qrTable.get(i * 2);
                b1 = currentVal == oldTable.qrTable.get(i * 2) ? (byte)0 : (currentVal ? (byte)(1 - currentTable.infinity) : (byte)(currentTable.infinity - 1));
                currentVal = currentTable.qrTable.get(i * 2 + 1);
                b2 = currentVal == oldTable.qrTable.get(i * 2 + 1) ? (byte)0 : (currentVal ? (byte)(1 - currentTable.infinity) : (byte)(currentTable.infinity - 1));
            }
            patchData[i] = (byte)(b1 << 4 | b2 & 0xF);
            if (patchData[i] == 0) continue;
            isPatchNeeded = true;
        }
        if (!isPatchNeeded) {
            return msgList.iterator();
        }
        byte compressor = 0;
        byte[] compressedPatchData = IOUtil.deflate(patchData);
        if (compressedPatchData.length < patchData.length) {
            patchData = compressedPatchData;
            compressor = 1;
        }
        byte sequenceSize = (byte)Math.ceil((double)patchData.length / 4096.0);
        byte sequenceNo = 1;
        int offset = 0;
        do {
            length = Math.min(4096, patchData.length - offset);
            QRPatchTableMsg msg = new QRPatchTableMsg(sequenceNo, sequenceSize, compressor, 4, patchData, offset, length);
            msgList.add(msg);
            sequenceNo = (byte)(sequenceNo + 1);
        } while ((offset += length) < patchData.length);
        return msgList.iterator();
    }

    private static int qrpHash(String x, int start, int end, byte bits) {
        int xor = 0;
        int j = 0;
        for (int i = start; i < end; ++i) {
            int b = Character.toLowerCase(x.charAt(i)) & 0xFF;
            xor ^= (b <<= j * 8);
            j = (j + 1) % 4;
        }
        long prod = (long)xor * 1327217884L;
        long ret = prod << 32;
        return (int)(ret >>>= 32 + (32 - bits));
    }
}

