/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.lang.SystemUtils;
import phex.utils.NLogger;

public class ThreadTracking {
    public static ThreadGroup threadPoolGroup;
    public static ThreadGroup rootThreadGroup;
    private static ThreadGroup systemGroup;

    public static void initialize() {
        systemGroup = Thread.currentThread().getThreadGroup();
        while (systemGroup.getParent() != null) {
            systemGroup = systemGroup.getParent();
        }
        if (SystemUtils.isJavaVersionAtLeast(1.5f)) {
            ThreadTracking.prepare15UncaughtExceptionHandler();
        }
        rootThreadGroup = new PhexThreadGroup("PhexRoot");
        threadPoolGroup = new PhexThreadGroup("PhexThreadPool");
    }

    private static void prepare15UncaughtExceptionHandler() {
        try {
            InvocationHandler invoHandler = new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method != null && "uncaughtException".equals(method.getName())) {
                        Thread thread = (Thread)args[0];
                        Throwable throwable = (Throwable)args[1];
                        NLogger.error("GLOBAL", (Object)("Uncaught exception: " + throwable.getMessage() + " in Thread: " + thread.getName()), throwable);
                    }
                    return null;
                }
            };
            Object expHandler = Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Class.forName("java.lang.Thread$UncaughtExceptionHandler")}, invoHandler);
            Method setMethod = Thread.class.getDeclaredMethod("setDefaultUncaughtExceptionHandler", Class.forName("java.lang.Thread$UncaughtExceptionHandler"));
            setMethod.invoke(null, expHandler);
        }
        catch (IllegalArgumentException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
        catch (ClassNotFoundException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
        catch (SecurityException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
        catch (NoSuchMethodException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
        catch (IllegalAccessException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
        catch (InvocationTargetException exp) {
            NLogger.error(ThreadTracking.class, (Object)exp, (Throwable)exp);
        }
    }

    private static class PhexThreadGroup
    extends ThreadGroup {
        public PhexThreadGroup(String name) {
            super(systemGroup, name);
        }

        public void uncaughtException(Thread t, Throwable e) {
            super.uncaughtException(t, e);
            NLogger.error("GLOBAL", (Object)("Uncaught exception: " + e.getMessage() + " in Thread: " + t.getName()), e);
        }
    }
}

