/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import edu.oswego.cs.dl.util.concurrent.ReentrantLock;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import phex.common.file.FileManager;
import phex.common.file.ManagedFileException;
import phex.common.file.ReadOnlyManagedFile;
import phex.utils.DirectByteBuffer;
import phex.utils.NLogger;

public class ManagedFile
implements ReadOnlyManagedFile {
    private static final int MAX_WRITE_TRIES = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    public static final int READ_ONLY_ACCESS = 0;
    public static final int READ_WRITE_ACCESS = 1;
    private ReentrantLock lock;
    private File fsFile;
    private int accessMode;
    private RandomAccessFile raFile;

    public ManagedFile(File file) {
        this.fsFile = file;
        this.lock = new ReentrantLock();
    }

    public void acquireFileLock() throws ManagedFileException {
        try {
            NLogger.debug(ManagedFile.class, (Object)("Acquire file lock " + this));
            this.lock.acquire();
            NLogger.debug(ManagedFile.class, (Object)("Acquired file lock " + this));
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("locking failed: interrupted", exp);
        }
    }

    public void releaseFileLock() {
        NLogger.debug(ManagedFile.class, (Object)("Releasing " + this));
        this.lock.release();
    }

    public File getFile() {
        return this.fsFile;
    }

    public void setAccessMode(int mode) throws ManagedFileException {
        if (this.accessMode == 0 && mode == 1) {
            this.closeFile();
        }
        this.accessMode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenFile() throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("open failes: interrupted", exp);
        }
        try {
            if (this.raFile != null) {
                FileManager.getInstance().trackFileInUse(this);
                return;
            }
            FileManager.getInstance().trackFileOpen(this);
            try {
                this.raFile = new RandomAccessFile(this.fsFile, this.accessMode == 0 ? "r" : "rwd");
            }
            catch (Exception exp) {
                throw new ManagedFileException("failed to open", exp);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile() throws ManagedFileException {
        if (this.raFile == null) {
            return;
        }
        try {
            this.lock.acquire();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("close failes: interrupted", exp);
        }
        try {
            try {
                NLogger.debug("ManagedFile", (Object)"Closing file.");
                this.raFile.close();
            }
            catch (Exception exp) {
                throw new ManagedFileException("failed to close", exp);
            }
        }
        finally {
            this.raFile = null;
            FileManager.getInstance().trackFileClose(this);
            this.lock.release();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(DirectByteBuffer buffer, long pos) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("write failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("write failes: raFile null");
            }
            FileChannel channel = this.raFile.getChannel();
            if (!channel.isOpen()) {
                throw new ManagedFileException("write failes: not open");
            }
            channel.position(pos);
            ByteBuffer byteBuffer = buffer.getInternalBuffer();
            int tryCount = 0;
            while (byteBuffer.position() != byteBuffer.limit()) {
                int written = channel.write(byteBuffer);
                if (written > 0) {
                    tryCount = 0;
                    continue;
                }
                if (tryCount >= 10) {
                    throw new ManagedFileException("write failes: max retries");
                }
                try {
                    Thread.sleep(100 * tryCount);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ManagedFileException("write failes: interrupted");
                    return;
                }
            }
        }
        catch (Exception exp) {
            throw new ManagedFileException("write fails", exp);
        }
        finally {
            this.lock.release();
        }
    }

    public void read(DirectByteBuffer buffer, long pos) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            FileChannel channel = this.raFile.getChannel();
            if (!channel.isOpen()) {
                throw new ManagedFileException("read failes: not open");
            }
            channel.position(pos);
            ByteBuffer byteBuffer = buffer.getInternalBuffer();
            while (channel.position() < channel.size() && byteBuffer.hasRemaining()) {
                channel.read(byteBuffer);
            }
        }
        catch (Exception exp) {
            throw new ManagedFileException("read fails", exp);
        }
        finally {
            this.lock.release();
        }
    }

    public void setLength(long newLength) throws ManagedFileException {
        try {
            this.lock.acquire();
        }
        catch (InterruptedException exp) {
            Thread.currentThread().interrupt();
            throw new ManagedFileException("read failes: interrupted", exp);
        }
        try {
            this.checkOpenFile();
            if (this.raFile == null) {
                throw new ManagedFileException("read failes: raFile null");
            }
            this.raFile.setLength(newLength);
        }
        catch (Exception exp) {
            throw new ManagedFileException("read fails", exp);
        }
        finally {
            this.lock.release();
        }
    }

    public String toString() {
        return super.toString() + ",File:" + this.fsFile + ",access:" + this.accessMode;
    }
}

