/*
 * Decompiled with CFR 0.152.
 */
package phex.common.file;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.utils.DirectByteBuffer;
import phex.utils.DirectByteBufferProvider;
import phex.utils.NLogger;

public class ManagedFileOutputStream
extends OutputStream {
    private DirectByteBuffer buffer;
    private ManagedFile managedFile;
    private long outputPosition;

    public ManagedFileOutputStream(ManagedFile managedFile, long outputPosition) {
        this.managedFile = managedFile;
        this.outputPosition = outputPosition;
        this.buffer = DirectByteBufferProvider.requestBuffer(65536);
    }

    public void write(int b) throws IOException {
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        if (!internalBuffer.hasRemaining()) {
            this.flush();
        }
        internalBuffer.put((byte)b);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        int toWrite;
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        for (int written = 0; written < length; written += toWrite) {
            toWrite = Math.min(length - written, internalBuffer.remaining());
            internalBuffer.put(b, offset + written, toWrite);
            if (internalBuffer.hasRemaining()) continue;
            this.flush();
        }
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)("Writen: " + new String(b, offset, length)));
        }
    }

    public void flush() throws IOException {
        ByteBuffer internalBuffer = this.buffer.getInternalBuffer();
        internalBuffer.flip();
        try {
            this.managedFile.write(this.buffer, this.outputPosition);
        }
        catch (ManagedFileException exp) {
            IOException ioExp = new IOException("ManagedFileException: " + exp.getMessage());
            ioExp.initCause(exp);
            throw ioExp;
        }
        this.outputPosition += (long)internalBuffer.limit();
        internalBuffer.clear();
        if (NLogger.isDebugEnabled(ManagedFileOutputStream.class)) {
            NLogger.debug(ManagedFileOutputStream.class, (Object)"Flushed");
        }
    }

    public void close() throws IOException {
        this.flush();
        this.buffer.release();
    }
}

