/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import java.text.NumberFormat;
import phex.utils.Localizer;

public final class NumberFormatUtils {
    public static final NumberFormat integerFormat = NumberFormat.getIntegerInstance();
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    public static final long ONE_GB = 0x40000000L;
    public static final long ONE_TB = 0x10000000000L;

    private NumberFormatUtils() {
    }

    public static String formatDecimal(double value, int precision) {
        String str = String.valueOf(value);
        int idx = str.indexOf(46);
        if (idx == -1) {
            if (precision != 0) {
                StringBuffer buffer = new StringBuffer(str);
                buffer.append(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                for (int i = 0; i < precision; ++i) {
                    buffer.append("0");
                }
                str = buffer.toString();
            }
        } else if (precision == 0) {
            str = str.substring(0, idx);
        } else {
            int digits = str.length() - idx - 1;
            if (digits < precision) {
                StringBuffer buffer = new StringBuffer(str);
                buffer.setCharAt(idx, Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                for (int i = 0; i < precision - digits; ++i) {
                    buffer.append("0");
                }
                str = buffer.toString();
            } else if (digits > precision) {
                StringBuffer buffer = new StringBuffer(str);
                buffer.setCharAt(idx, Localizer.getDecimalFormatSymbols().getDecimalSeparator());
                str = buffer.substring(0, idx + precision + 1);
            }
        }
        return str;
    }

    public static String formatSize(long size) {
        return integerFormat.format(size);
    }

    public static String formatFullByteSize(long size) {
        return integerFormat.format(size) + " " + Localizer.getString("BytesToken");
    }

    public static String formatSignificantByteSize(double size) {
        int precision;
        double divider;
        String text;
        if (size < 1024.0) {
            text = Localizer.getString("BytesToken");
            divider = 1.0;
            precision = 0;
        } else if (size < 1048576.0) {
            text = Localizer.getString("KBToken");
            divider = 1024.0;
            precision = 1;
        } else if (size < 1.073741824E9) {
            text = Localizer.getString("MBToken");
            divider = 1048576.0;
            precision = 1;
        } else if (size < 1.099511627776E12) {
            text = Localizer.getString("GBToken");
            divider = 1.073741824E9;
            precision = 2;
        } else {
            text = Localizer.getString("TBToken");
            divider = 1.099511627776E12;
            precision = 3;
        }
        double d = size / divider;
        String valStr = NumberFormatUtils.formatDecimal(d, precision);
        return valStr + " " + text;
    }

    public static String formatSignificantByteSize(Number number) {
        return NumberFormatUtils.formatSignificantByteSize(number.doubleValue());
    }
}

