/*
 * Decompiled with CFR 0.152.
 */
package phex.common.format;

import phex.utils.Localizer;

public final class TimeFormatUtils {
    private TimeFormatUtils() {
    }

    public static String formatSignificantElapsedTime(long seconds) {
        long days = seconds / 86400L;
        if (days > 0L) {
            Object[] args = new Object[]{new Long(days), new Integer((int)(seconds / 3600L % 24L))};
            return Localizer.getFormatedString("TimeFormatDH", args);
        }
        int hours = (int)(seconds / 3600L % 24L);
        if (hours > 0) {
            Object[] args = new Object[]{new Integer(hours), new Integer((int)(seconds / 60L % 60L))};
            return Localizer.getFormatedString("TimeFormatHM", args);
        }
        int minutes = (int)(seconds / 60L % 60L);
        if (minutes > 0) {
            Object[] args = new Object[]{new Integer(minutes), new Integer((int)(seconds % 60L))};
            return Localizer.getFormatedString("TimeFormatMS", args);
        }
        int secs = (int)(seconds % 60L);
        Object[] args = new Object[]{new Integer(secs)};
        return Localizer.getFormatedString("TimeFormatS", args);
    }

    public static String convertSecondsToTime(int seconds) {
        StringBuffer buffer = new StringBuffer();
        int days = seconds / 86400;
        int hours = seconds / 3600 % 24;
        int minutes = seconds / 60 % 60;
        int secs = seconds % 60;
        if (days > 0) {
            buffer.append(Integer.toString(days));
            buffer.append(":");
            if (hours < 10) {
                buffer.append("0");
            }
        }
        if (days > 0 || hours > 0) {
            buffer.append(Integer.toString(hours));
            buffer.append(":");
            if (minutes < 10) {
                buffer.append("0");
            }
        }
        buffer.append(Integer.toString(minutes));
        buffer.append(":");
        if (secs < 10) {
            buffer.append("0");
        }
        buffer.append(Integer.toString(secs));
        return buffer.toString();
    }
}

