/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.BrowseHostException;
import phex.download.PushHandler;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.MsgManager;
import phex.msg.QueryResponseMsg;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.query.BrowseHostResults;
import phex.utils.NLogger;

public class BrowseHostConnection {
    private final BrowseHostResults results;
    private final DestAddress address;
    private final GUID hostGUID;

    public BrowseHostConnection(DestAddress aAddress, GUID aHostGUID, BrowseHostResults results) {
        this.address = aAddress;
        this.hostGUID = aHostGUID;
        this.results = results;
    }

    public void sendBrowseHostRequest() throws IOException, BrowseHostException {
        HTTPResponse response;
        SocketFacade socket;
        block13: {
            NLogger.debug(BrowseHostConnection.class, (Object)("Connection for Browse Host to " + this.address));
            this.results.setBrowseHostStatus((short)1);
            try {
                socket = OIOSocketFactory.connect(this.address, ServiceManager.sCfg.mNetConnectionTimeout);
            }
            catch (IOException exp) {
                if (this.hostGUID == null) {
                    throw exp;
                }
                socket = PushHandler.requestSocketViaPush(this.hostGUID, 50484558L);
                if (socket != null) break block13;
                throw new IOException("Push request failed");
            }
        }
        Connection connection = new Connection(socket, BandwidthManager.getInstance().getNetworkBandwidthController());
        HTTPRequest request = new HTTPRequest("GET", "/", true);
        request.addHeader(new HTTPHeader("Host", this.address.getFullHostName()));
        request.addHeader(new HTTPHeader("Accept", "application/x-gnutella-packets"));
        request.addHeader(new HTTPHeader("Content-Length", "0"));
        request.addHeader(new HTTPHeader("Connection", "close"));
        String httpRequestStr = request.buildHTTPRequestString();
        NLogger.debug(BrowseHostConnection.class, (Object)("Sending Browse Host request: " + httpRequestStr));
        connection.write(httpRequestStr.toString().getBytes());
        try {
            response = HTTPProcessor.parseHTTPResponse(connection);
        }
        catch (HTTPMessageException exp) {
            throw new BrowseHostException("Invalid HTTP Response: " + exp.getMessage());
        }
        NLogger.debug(BrowseHostConnection.class, (Object)("Received Browse Host response: " + response.buildHTTPResponseString()));
        if (response.getStatusCode() < 200 || response.getStatusCode() > 299) {
            throw new BrowseHostException("Browse host request not successfull. StatusCode: " + response.getStatusCode() + " " + response.getStatusReason());
        }
        HTTPHeader typeHeader = response.getHeader("Content-Type");
        if (typeHeader == null) {
            throw new BrowseHostException("Unknwon content-type.");
        }
        if (typeHeader.getValue().equals("application/x-gnutella-packets")) {
            MsgHeader header;
            this.results.setBrowseHostStatus((short)2);
            MsgManager msgMgr = MsgManager.getInstance();
            byte[] headerBuffer = new byte[23];
            while ((header = MessageProcessor.parseMessageHeader(connection, headerBuffer)) != null) {
                if (header.getPayload() != -127) {
                    throw new BrowseHostException("Wrong header payload. Expecting query hit.");
                }
                QueryResponseMsg message = null;
                try {
                    message = (QueryResponseMsg)MessageProcessor.parseMessage(header, connection);
                }
                catch (InvalidMessageException exp) {
                    NLogger.debug(BrowseHostConnection.class, (Object)exp, (Throwable)exp);
                    throw new IOException("Invalid message returned: " + exp.getMessage());
                }
                msgMgr.getQueryResultMonitor().processResponse(message);
                this.results.processResponse(message);
            }
        } else {
            throw new BrowseHostException("Not supported content-type. " + typeHeader.getValue());
        }
    }
}

