/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import phex.msg.Message;
import phex.utils.CircularQueue;

public class FlowControlQueue {
    private int dropCount = 0;
    private int burstSize;
    private int currentBurstCount;
    private int msgTimeout;
    private boolean isLIFO;
    private CircularQueue msgQueue;

    public FlowControlQueue(int burstSize, int msgTimeout, int maxSize, boolean isLIFO) {
        this.msgQueue = new CircularQueue(maxSize);
        this.burstSize = burstSize;
        this.msgTimeout = msgTimeout;
        this.isLIFO = isLIFO;
    }

    public void addMessage(Message message) {
        Object dropObj = this.msgQueue.addToTail(message);
        if (dropObj != null) {
            ++this.dropCount;
        }
    }

    public Message removeMessage() {
        Message message;
        if (this.currentBurstCount == this.burstSize) {
            return null;
        }
        long expiredCreationTime = System.currentTimeMillis() - (long)this.msgTimeout;
        while (true) {
            if ((message = this.removeNextMessage()) == null) {
                return null;
            }
            if (message.getCreationTime() >= expiredCreationTime) break;
            ++this.dropCount;
        }
        ++this.currentBurstCount;
        return message;
    }

    public void initNewMessageBurst() {
        this.currentBurstCount = 0;
    }

    public int getAndResetDropCount() {
        int tmpDropCount = this.dropCount;
        this.dropCount = 0;
        return tmpDropCount;
    }

    private Message removeNextMessage() {
        if (this.msgQueue.isEmpty()) {
            return null;
        }
        if (this.isLIFO) {
            return (Message)this.msgQueue.removeFromTail();
        }
        return (Message)this.msgQueue.removeFromHead();
    }
}

