/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.io.OutputStream;
import phex.chat.ChatManager;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.connection.NetworkManager;
import phex.download.PushHandler;
import phex.host.Host;
import phex.host.HostManager;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.GUID;
import phex.net.connection.Connection;
import phex.net.presentation.SocketFacade;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;

public class IncomingConnectionDispatcher
implements Runnable {
    public static final String GET_REQUEST_PREFIX = "GET ";
    public static final String HEAD_REQUEST_PREFIX = "HEAD ";
    public static final String GIV_REQUEST_PREFIX = "GIV ";
    public static final String CHAT_REQUEST_PREFIX = "CHAT ";
    public static final String URI_DOWNLOAD_PREFIX = "PHEX_URI ";
    public static final String MAGMA_DOWNLOAD_PREFIX = "PHEX_MAGMA ";
    public static final String RSS_DOWNLOAD_PREFIX = "PHEX_RSS ";
    private final SocketFacade socket;

    public IncomingConnectionDispatcher(SocketFacade socket) {
        this.socket = socket;
    }

    public void run() {
        block15: {
            GnutellaInputStream gInStream = null;
            try {
                NetworkManager networkMgr = NetworkManager.getInstance();
                if (!networkMgr.isNetworkJoined() && !this.socket.getRemoteAddress().isLocalHost()) {
                    throw new IOException("Network not joined.");
                }
                this.socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
                BandwidthController bwController = BandwidthManager.getInstance().getNetworkBandwidthController();
                Connection connection = new Connection(this.socket, bwController);
                String requestLine = connection.readLine();
                if (requestLine == null) {
                    throw new IOException("Disconnected from remote host during handshake");
                }
                NLogger.debug("INCOMING_CONNECTION", (Object)("ConnectionRequest " + requestLine));
                String greeting = networkMgr.getGnutellaNetwork().getNetworkGreeting();
                if (requestLine.startsWith(greeting + "/")) {
                    DestAddress address = this.socket.getRemoteAddress();
                    Host host = new Host(address, connection);
                    host.setType(Host.TYPE_INCOMING);
                    host.setStatus(3, "");
                    HostManager.getInstance().acceptIncomingConnection(host, requestLine);
                    break block15;
                }
                if (requestLine.startsWith(GET_REQUEST_PREFIX) || requestLine.startsWith(HEAD_REQUEST_PREFIX)) {
                    HTTPRequest httpRequest = HTTPProcessor.parseHTTPRequest(requestLine);
                    HTTPProcessor.parseHTTPHeaders(httpRequest, connection);
                    NLogger.debug("INCOMING_CONNECTION", (Object)(httpRequest.getRequestMethod() + " Request: " + httpRequest.buildHTTPRequestString()));
                    if (httpRequest.isGnutellaRequest()) {
                        UploadManager.getInstance().handleUploadRequest(connection, httpRequest);
                    } else {
                        ShareManager.getInstance().httpRequestHandler(connection, httpRequest);
                    }
                    break block15;
                }
                if (requestLine.startsWith(GIV_REQUEST_PREFIX)) {
                    this.handleIncommingGIV(requestLine);
                    break block15;
                }
                if (requestLine.startsWith(CHAT_REQUEST_PREFIX)) {
                    DestAddress address = this.socket.getRemoteAddress();
                    NLogger.debug("INCOMING_CONNECTION", (Object)("Chat request from: " + address));
                    gInStream = connection.getInputStream();
                    ChatManager.getInstance().acceptChat(this.socket, gInStream, address);
                    break block15;
                }
                if (requestLine.startsWith(URI_DOWNLOAD_PREFIX)) {
                    this.handleIncommingUriDownload(requestLine);
                    break block15;
                }
                if (requestLine.startsWith(MAGMA_DOWNLOAD_PREFIX)) {
                    this.handleIncommingMagmaDownload(requestLine);
                    break block15;
                }
                if (requestLine.startsWith(RSS_DOWNLOAD_PREFIX)) {
                    this.handleIncommingRSSDownload(requestLine);
                    break block15;
                }
                throw new IOException("Unknown connection request: " + requestLine);
            }
            catch (HTTPMessageException exp) {
                NLogger.debug("INCOMING_CONNECTION", (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (IOException exp) {
                NLogger.debug("INCOMING_CONNECTION", (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
            catch (Exception exp) {
                NLogger.error("INCOMING_CONNECTION", (Object)exp, (Throwable)exp);
                IOUtil.closeQuietly(gInStream);
                IOUtil.closeQuietly(this.socket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingUriDownload(String requestLine) throws IOException {
        try {
            if (!this.socket.getRemoteAddress().isLocalHost()) {
                return;
            }
            OutputStream outStream = this.socket.getOutputStream();
            outStream.write("OK".getBytes());
            outStream.flush();
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String uriToken = requestLine.substring(URI_DOWNLOAD_PREFIX.length() + 1);
        NetworkManager.getInstance().fireIncomingUriDownload(uriToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingMagmaDownload(String requestLine) throws IOException {
        try {
            if (!this.socket.getRemoteAddress().isLocalHost()) {
                return;
            }
            OutputStream outStream = this.socket.getOutputStream();
            outStream.write("OK".getBytes());
            outStream.flush();
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String fileNameToken = requestLine.substring(MAGMA_DOWNLOAD_PREFIX.length() + 1);
        NetworkManager.getInstance().fireIncomingMagmaDownload(fileNameToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncommingRSSDownload(String requestLine) throws IOException {
        try {
            if (!this.socket.getRemoteAddress().isLocalHost()) {
                return;
            }
            OutputStream outStream = this.socket.getOutputStream();
            outStream.write("OK".getBytes());
            outStream.flush();
        }
        finally {
            IOUtil.closeQuietly(this.socket);
        }
        String fileNameToken = requestLine.substring(RSS_DOWNLOAD_PREFIX.length() + 1);
        NetworkManager.getInstance().fireIncomingRSSDownload(fileNameToken);
    }

    private void handleIncommingGIV(String requestLine) {
        String remainder = requestLine.substring(4);
        try {
            int fileNumIdx = remainder.indexOf(58);
            remainder.substring(0, fileNumIdx);
            int guidIdx = remainder.indexOf(47, fileNumIdx);
            String guidStr = remainder.substring(fileNumIdx + 1, guidIdx);
            String givenFileName = remainder.substring(guidIdx + 1);
            givenFileName = URLCodecUtils.decodeURL(givenFileName);
            GUID givenGUID = new GUID(guidStr);
            PushHandler.handleIncommingGIV(this.socket, givenGUID, givenFileName);
        }
        catch (IndexOutOfBoundsException exp) {
            NLogger.error("INCOMING_CONNECTION", (Object)("Failed to parse GIV: " + requestLine), (Throwable)exp);
        }
    }
}

