/*
 * Decompiled with CFR 0.152.
 */
package phex.connection;

import java.io.IOException;
import java.util.EventListener;
import phex.common.AbstractManager;
import phex.common.GeneralGnutellaNetwork;
import phex.common.GnutellaNetwork;
import phex.common.NamedGnutellaNetwork;
import phex.common.ServiceManager;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.EventListenerList;
import phex.event.LoopbackListener;
import phex.event.NetworkListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.MainFrame;
import phex.gwebcache.GWebCacheManager;
import phex.host.HostManager;
import phex.net.OIOServer;
import phex.net.OnlineObserver;
import phex.net.Server;
import phex.net.presentation.PresentationManager;
import phex.query.QueryManager;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.NLogger;

public class NetworkManager
extends AbstractManager {
    private GnutellaNetwork gnutellaNetwork;
    private boolean isNetworkJoined;
    private boolean isConnected;
    private DestAddress forcedAddress;
    private DestAddress localAddress;
    private Server server;
    private OnlineObserver onlineObserver;
    private EventListenerList listenerList = new EventListenerList();

    private NetworkManager() {
        this.updateGnutellaNetwork();
        this.isNetworkJoined = ServiceManager.sCfg.mAutoJoin;
        this.isConnected = ServiceManager.sCfg.mAutoConnect;
    }

    public static NetworkManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.onlineObserver = new OnlineObserver();
        return true;
    }

    public boolean onPostInitialization() {
        this.server = new OIOServer();
        try {
            this.server.startup();
        }
        catch (IOException exp) {
            NLogger.error("STARTUP", (Object)exp, (Throwable)exp);
        }
        if (ServiceManager.sCfg.mMyIP.length() > 0) {
            IpAddress ip = new IpAddress(AddressUtils.parseIP(ServiceManager.sCfg.mMyIP));
            this.setForcedHostIP(ip);
        }
        if (this.isNetworkJoined) {
            HostManager hostMgr = HostManager.getInstance();
            hostMgr.getCaughtHostsContainer().initializeCaughtHostsContainer();
            hostMgr.getFavoritesContainer().initializeFavorites();
            GWebCacheManager gWebCacheMgr = GWebCacheManager.getInstance();
            gWebCacheMgr.getGWebCacheContainer().initializeGWebCacheContainer();
            UdpHostCacheManager udpHostCacheMgr = UdpHostCacheManager.getInstance();
            udpHostCacheMgr.getUdpHostCacheContainer().initialize();
        }
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.server.shutdown(false);
    }

    public void restartServer() throws IOException {
        this.server.restart();
    }

    public boolean hasConnectedIncoming() {
        return this.server.hasConnectedIncoming();
    }

    public synchronized void connectToNetwork() {
        if (this.isConnected) {
            return;
        }
        this.isConnected = true;
        this.onlineObserver.markSuccessfulConnection();
        if (!this.isNetworkJoined) {
            this.joinNetwork();
        }
        this.fireConnectedToNetwork();
    }

    public synchronized void disconnectNetwork() {
        this.isConnected = false;
        this.fireDisconnectedFromNetwork();
    }

    public synchronized void joinNetwork() {
        this.updateGnutellaNetwork();
        HostManager hostMgr = HostManager.getInstance();
        hostMgr.getCaughtHostsContainer().initializeCaughtHostsContainer();
        hostMgr.getFavoritesContainer().initializeFavorites();
        GWebCacheManager gWebCacheMgr = GWebCacheManager.getInstance();
        gWebCacheMgr.getGWebCacheContainer().initializeGWebCacheContainer();
        this.isNetworkJoined = true;
        if (!this.isConnected && ServiceManager.sCfg.mAutoConnect) {
            this.connectToNetwork();
        }
        MainFrame frame = GUIRegistry.getInstance().getMainFrame();
        frame.setTitle();
    }

    public synchronized void leaveNetwork() {
        if (this.isNetworkJoined) {
            this.isNetworkJoined = false;
            this.disconnectNetwork();
            MainFrame frame = GUIRegistry.getInstance().getMainFrame();
            frame.setTitle();
            HostManager hostMgr = HostManager.getInstance();
            hostMgr.removeAllNetworkHosts();
            QueryManager.getInstance().getSearchContainer().stopAllSearches();
            hostMgr.getCaughtHostsContainer().saveHostsContainer();
            hostMgr.getFavoritesContainer().saveFavoriteHosts();
        }
    }

    public synchronized boolean isNetworkJoined() {
        return this.isNetworkJoined;
    }

    public synchronized boolean isConnected() {
        return this.isConnected;
    }

    public GnutellaNetwork getGnutellaNetwork() {
        return this.gnutellaNetwork;
    }

    private void updateGnutellaNetwork() {
        if (ServiceManager.sCfg.mCurrentNetwork.equals("<General Gnutella Network>")) {
            if (this.gnutellaNetwork == null || !(this.gnutellaNetwork instanceof GeneralGnutellaNetwork)) {
                this.gnutellaNetwork = new GeneralGnutellaNetwork();
            }
        } else if (this.gnutellaNetwork == null || !this.gnutellaNetwork.getName().equals(ServiceManager.sCfg.mCurrentNetwork)) {
            this.gnutellaNetwork = new NamedGnutellaNetwork(ServiceManager.sCfg.mCurrentNetwork);
        }
    }

    public OnlineObserver getOnlineObserver() {
        return this.onlineObserver;
    }

    public DestAddress getLocalAddress() {
        if (this.forcedAddress != null) {
            return this.forcedAddress;
        }
        return this.localAddress;
    }

    public void updateLocalAddress(DestAddress updateAddress) {
        if (this.forcedAddress != null) {
            return;
        }
        if (this.localAddress == null || !this.localAddress.equals(updateAddress)) {
            updateAddress.setPort(this.server.getListeningLocalPort());
            this.localAddress = updateAddress;
            this.server.resetFirewallCheck();
            this.fireNetworkIPChanged();
        }
    }

    public void setForcedHostIP(IpAddress forcedHostIP) {
        PresentationManager presentationMgr = PresentationManager.getInstance();
        if (forcedHostIP == null) {
            this.forcedAddress = null;
            ServiceManager.sCfg.mMyIP = "";
            IpAddress hostIP = this.server.resolveLocalHostIP();
            int port = this.server.getListeningLocalPort();
            DestAddress address = presentationMgr.createHostAddress(hostIP, port);
            this.updateLocalAddress(address);
            return;
        }
        if (!forcedHostIP.isValidIP()) {
            throw new IllegalArgumentException("Invalid IP " + forcedHostIP);
        }
        ServiceManager.sCfg.mMyIP = forcedHostIP.getFormatedString();
        this.forcedAddress = presentationMgr.createHostAddress(forcedHostIP, this.server.getListeningLocalPort());
        this.fireNetworkIPChanged();
    }

    public void addNetworkListener(NetworkListener listener) {
        this.listenerList.add(NetworkListener.class, listener);
    }

    public void removeNetworkListener(NetworkListener listener) {
        this.listenerList.remove(NetworkListener.class, listener);
    }

    public void addLoopbackListener(LoopbackListener listener) {
        this.listenerList.add(LoopbackListener.class, listener);
    }

    public void removeLoopbackListener(LoopbackListener listener) {
        this.listenerList.remove(LoopbackListener.class, listener);
    }

    public void fireConnectedToNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    NetworkListener listener = (NetworkListener)listeners[i];
                    listener.connectedToNetwork();
                }
            }
        });
    }

    public void fireDisconnectedFromNetwork() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    NetworkListener listener = (NetworkListener)listeners[i];
                    listener.disconnectedFromNetwork();
                }
            }
        });
    }

    public void fireNetworkIPChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$NetworkListener == null ? (class$phex$event$NetworkListener = NetworkManager.class$("phex.event.NetworkListener")) : class$phex$event$NetworkListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    NetworkListener listener = (NetworkListener)listeners[i];
                    listener.networkIPChanged(NetworkManager.this.getLocalAddress());
                }
            }
        });
    }

    public void fireIncomingUriDownload(final String uri) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    LoopbackListener listener = (LoopbackListener)listeners[i];
                    listener.incommingUriDownload(uri);
                }
            }
        });
    }

    public void fireIncomingMagmaDownload(final String magmaFile) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    LoopbackListener listener = (LoopbackListener)listeners[i];
                    listener.incommingMagmaDownload(magmaFile);
                }
            }
        });
    }

    public void fireIncomingRSSDownload(final String rssFile) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                EventListener[] listeners = NetworkManager.this.listenerList.getListeners(class$phex$event$LoopbackListener == null ? (class$phex$event$LoopbackListener = NetworkManager.class$("phex.event.LoopbackListener")) : class$phex$event$LoopbackListener);
                for (int i = listeners.length - 1; i >= 0; --i) {
                    LoopbackListener listener = (LoopbackListener)listeners[i];
                    listener.incommingRSSDownload(rssFile);
                }
            }
        });
    }

    private static class Holder {
        protected static final NetworkManager manager = new NetworkManager();

        private Holder() {
        }
    }
}

