/*
 * Decompiled with CFR 0.152.
 */
package phex.connection.handshake;

import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.connection.ConnectionConstants;
import phex.connection.NetworkManager;
import phex.connection.handshake.HandshakeStatus;
import phex.connection.handshake.LeafHandshakeHandler;
import phex.connection.handshake.PeerHandshakeHandler;
import phex.connection.handshake.UltrapeerHandshakeHandler;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.HTTPHeader;
import phex.http.HTTPHeaderGroup;

public abstract class HandshakeHandler
implements ConnectionConstants {
    protected Host connectedHost;

    public HandshakeHandler(Host connectedHost) {
        this.connectedHost = connectedHost;
    }

    protected HTTPHeaderGroup createDefaultHandshakeHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.ACCEPT_HANDSHAKE_GROUP);
        DestAddress myAddress = NetworkManager.getInstance().getLocalAddress();
        openHeaders.addHeader(new HTTPHeader("Listen-IP", myAddress.getFullHostName()));
        DestAddress remoteAddress = this.connectedHost.getHostAddress();
        IpAddress ipAddress = remoteAddress.getIpAddress();
        openHeaders.addHeader(new HTTPHeader("Remote-IP", ipAddress.getFormatedString() + ":" + remoteAddress.getPort()));
        if (ServiceManager.sCfg.isDeflateConnectionAccepted) {
            openHeaders.addHeader(new HTTPHeader("Accept-Encoding", "deflate"));
        }
        return openHeaders;
    }

    public HTTPHeaderGroup createOutgoingHandshakeHeaders() {
        HTTPHeaderGroup outHeaders = this.createDefaultHandshakeHeaders();
        return outHeaders;
    }

    protected HandshakeStatus createCrawlerHandshakeStatus() {
        Host[] ultrapeers;
        Host[] leafs;
        HTTPHeaderGroup crawlerHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        HostManager hostMgr = HostManager.getInstance();
        NetworkHostsContainer networkHostsContainer = hostMgr.getNetworkHostsContainer();
        boolean isUltrapeer = hostMgr.isUltrapeer();
        crawlerHeaders.addHeader(new HTTPHeader("X-Ultrapeer", String.valueOf(isUltrapeer)));
        if (isUltrapeer && (leafs = networkHostsContainer.getLeafConnections()).length > 0) {
            String leafAddressString = this.buildHostAddressString(leafs, leafs.length);
            crawlerHeaders.addHeader(new HTTPHeader("Leaves", leafAddressString));
        }
        if ((ultrapeers = networkHostsContainer.getUltrapeerConnections()).length > 0) {
            String ultrapeerAddressString = this.buildHostAddressString(ultrapeers, ultrapeers.length);
            crawlerHeaders.addHeader(new HTTPHeader("Peers", ultrapeerAddressString));
        }
        return new HandshakeStatus(200, "OK", crawlerHeaders);
    }

    protected HTTPHeaderGroup createRejectOutgoingHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        return openHeaders;
    }

    protected HTTPHeaderGroup createRejectIncomingHeaders() {
        HTTPHeaderGroup openHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
        openHeaders.addHeader(new HTTPHeader("Remote-IP", this.connectedHost.getHostAddress().getFullHostName()));
        NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
        Host[] ultrpeers = networkHostsContainer.getUltrapeerConnections();
        String ultrapeerAddressString = this.buildHostAddressString(ultrpeers, ultrpeers.length);
        openHeaders.addHeader(new HTTPHeader("X-Try-Ultrapeers", ultrapeerAddressString));
        return openHeaders;
    }

    public HandshakeStatus createHandshakeResponse(HandshakeStatus hostResponse, boolean isOutgoing) {
        if (isOutgoing) {
            HTTPHeaderGroup myHeaders = new HTTPHeaderGroup(HTTPHeaderGroup.COMMON_HANDSHAKE_GROUP);
            if (hostResponse.isDeflateAccepted()) {
                myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", myHeaders);
        }
        if (HostManager.getInstance().getNetworkHostsContainer().hasPeerSlotsAvailable()) {
            HTTPHeaderGroup myHeaders = this.createDefaultHandshakeHeaders();
            if (hostResponse.isDeflateAccepted()) {
                myHeaders.addHeader(new HTTPHeader("Content-Encoding", "deflate"));
            }
            return new HandshakeStatus(200, "OK", myHeaders);
        }
        return new HandshakeStatus(503, "I am busy.", this.createRejectIncomingHeaders());
    }

    public static HandshakeHandler createHandshakeHandler(Host connectedHost) {
        if (HostManager.getInstance().isAbleToBecomeUltrapeer()) {
            return new UltrapeerHandshakeHandler(connectedHost);
        }
        if (ServiceManager.sCfg.allowToBecomeLeaf) {
            return new LeafHandshakeHandler(connectedHost);
        }
        return new PeerHandshakeHandler(connectedHost);
    }

    protected String buildHostAddressString(Host[] hosts, int max) {
        StringBuffer buffer = new StringBuffer();
        max = Math.min(max, hosts.length);
        for (int i = 0; i < hosts.length; ++i) {
            DestAddress address = hosts[i].getHostAddress();
            buffer.append(address.getFullHostName());
            if (i >= hosts.length - 1) continue;
            buffer.append(",");
        }
        return buffer.toString();
    }

    protected boolean isCrawlerConnection(HTTPHeaderGroup headers) {
        HTTPHeader crawlerHeader = headers.getHeader("Crawler");
        if (crawlerHeader == null) {
            return false;
        }
        try {
            float crawlerVersion = crawlerHeader.floatValue();
            return crawlerVersion >= 0.1f;
        }
        catch (NumberFormatException exp) {
            return false;
        }
    }
}

